
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for the line plot
y1 = np.random.normal(3000, 500, 100)
y2 = np.random.normal(5000, 800, 100)
y3 = np.random.normal(2000, 600, 100)

kde1 = gaussian_kde(y1)
kde2 = gaussian_kde(y2)
kde3 = gaussian_kde(y3)

x_range = np.linspace(0, 7000, 100)
labels = ["Country A", "Country B", "Country C"]
title = "Tourist Arrivals by Country"
xlabel = "Number of Tourists"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific size to match the original image's dimensions
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(10, 6), gridspec_kw={"height_ratios": [3, 2]}
)

# Line plot
ax1.fill_between(x_range, kde1(x_range), color="#8dc9f6", alpha=0.4)
ax1.fill_between(x_range, kde2(x_range), color="#d3a4ee", alpha=0.4)
ax1.fill_between(x_range, kde3(x_range), color="#8df6e6", alpha=0.4)
ax1.plot(x_range, kde1(x_range), label=labels[0], color="#0073cf", linestyle='-', linewidth=2)
ax1.plot(x_range, kde2(x_range), label=labels[1], color="#ab47bc", linestyle='--', linewidth=2)
ax1.plot(x_range, kde3(x_range), label=labels[2], color="#00796b", linestyle='-.', linewidth=2)
ax1.legend(title=title, loc="upper right")
ax1.set_xticks([])
ax1.set_yticks([])
ax1.grid(True)

# Box plot
box = ax2.boxplot(
    [y1, y2, y3], vert=False, patch_artist=True, medianprops={"color": "black"}
)
colors = ["#8dc9f6", "#d3a4ee", "#8df6e6"]
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

ax2.set_xlabel(xlabel)
ax2.set_yticks([])
ax2.set_xlim(0, 7000)
ax2.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_93.pdf", bbox_inches="tight")
