
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
x = [2000, 2004, 2008, 2012, 2016, 2020]
y = [48, 52, 50, 53, 47, 51]
x2 = [2024]
y2 = [49]

# Labels and Plot Types
label_Party_A = "Party A"
label_Party_B = "Party B"
ax1_txt = [
    "48% - 2000",
    "52% - 2004",
    "50% - 2008",
    "53% - 2012",
    "47% - 2016",
    "51% - 2020"
]
ax2_txt = "49% - 2024"

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Voter Approval Rating (%)"
xticklabels1 = [str(year) for year in x]
ylim_values = [45, 55]
yticks_values = [45, 47, 49, 51, 53, 55]
xlim_values = [1998, 2026]
xticks_values = [2000, 2004, 2008, 2012, 2016, 2020, 2024]
xticklabels2 = ["2000", "2004", "2008", "2012", "2016", "2020", "2024"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Plot the data
ax.plot(x, y, "g^-", label=label_Party_A, linewidth=2, markersize=8)
ax.plot(x2, y2, "bs", markersize=10, label=label_Party_B)

# Annotate the points
for i, txt in enumerate(ax1_txt):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
ax.annotate(
    ax2_txt,
    (x2[0], y2[0]),
    textcoords="offset points",
    xytext=(0, 5),
    ha="center",
    color="black",
    fontsize=10,
)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=10)
ax.set_ylabel(ylabel_value, fontsize=10)
ax.set_title("Voter Approval Ratings Over the Years")

# Set the legend
legend = ax.legend(fontsize=10)

# Adjust x-axis labels
ax.set_xticks(x)
ax.set_xticklabels(xticklabels1, ha="center")
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlim(xlim_values)
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels2, ha="center")

# Add grid lines for clarity
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_97.pdf", bbox_inches="tight")
