
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm
from matplotlib.image import NonUniformImage

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
interp = "nearest"

# Time array
time = np.linspace(0, 10, 100)
# Simulate customer satisfaction scores with variations
satisfaction = np.cos(time / 2) * np.exp(-time / 5)
satisfaction2 = np.sin(time / 2) * np.exp(-time / 5)

# Using a highly nonlinear transformation for variety
time2 = time ** 1.5

# Z values, simulating customer satisfaction scores in a grid
x = np.linspace(-5, 5, 100)
y = np.linspace(-5, 5, 100)
z = np.cos(x[np.newaxis, :]**2 + y[:, np.newaxis]**2)
title=["Customer Satisfaction (nearest)","Transformed Satisfaction (nearest)","Transformed Satisfaction (bilinear)", "Customer Satisfaction (bilinear)"]
suptitle = "Customer Satisfaction Over Time"
xlabel = "Time (months)"
ylabel = "Satisfaction Score"
xlim = [[0, 10], [0, 31.6], [0, 10], [0, 31.6]]
ylim = [[-1, 1], [-1, 1], [-1, 1], [-1, 1]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(10, 8))
fig.suptitle(suptitle, fontsize="large")

# Color map configuration
cmap = cm.coolwarm

ax = axs[0, 0]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[0][0], xlim[0][1], ylim[0][0], ylim[0][1]),
    cmap=cmap,
)
im.set_data(time, satisfaction, z)
ax.add_image(im)
ax.set_xlim(xlim[0])
ax.set_ylim(ylim[0])
ax.set_title(title[0])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax = axs[0, 1]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[1][0], xlim[1][1], ylim[0][0], ylim[0][1]),
    cmap=cmap,
)
im.set_data(time2, satisfaction2, z)
ax.add_image(im)
ax.set_xlim(xlim[1])
ax.set_ylim(ylim[1])
ax.set_title(title[1])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

interp = "bilinear"

ax = axs[1, 0]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[2][0], xlim[2][1], ylim[2][0], ylim[2][1]),
    cmap=cmap,
)
im.set_data(time, satisfaction, z)
ax.add_image(im)
ax.set_xlim(xlim[2])
ax.set_ylim(ylim[2])
ax.set_title(title[2])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax = axs[1, 1]
im = NonUniformImage(
    ax,
    interpolation=interp,
    extent=(xlim[3][0], xlim[3][1], ylim[3][0], ylim[3][1]),
    cmap=cmap,
)
im.set_data(time2, satisfaction2, z)
ax.add_image(im)
ax.set_xlim(xlim[3])
ax.set_ylim(ylim[3])
ax.set_title(title[3])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_100.pdf", bbox_inches="tight")
