

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for Financial Market Trends
months = np.arange(14)
stock_trend_a = np.array(
    [150, 130, 120, 220] + sorted(list(np.random.randint(100, 300, 10)))
)
stock_trend_b = np.array(
    [160, 140, 115, 220] + sorted(list(np.random.randint(100, 300, 10)))
)
trend_projection = [sorted(np.random.randint(50, 300, 10), reverse=True) for i in range(2)]

# Creating an array of months to adjust spacing for the bars
adjusted_months = np.array(months, dtype=float)
# Adjust spacing for purple and the three bars before it
adjusted_months[3] += 0.5
# Adjust spacing between the red/blue bars and the others
adjusted_months[4:] += 4

title = "Financial Market - Stock A"
xlabel = "Months"
ylabel = "Stock Value"
ylim = [0, 350]
axhline = 220

title2 = "Financial Market - Stock B"
xlabel2 = "Months"
ylabel2 = "Stock Value"
ylim2 = [0, 350]
axhline2 = 220
xticks = adjusted_months[4:]
xtickslabel = np.arange(0, 10)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image dimensions
stock_colors_a = [plt.cm.Greens(i) for i in np.linspace(0.6, 0.3, 10)]
stock_colors_b = [plt.cm.Oranges(i) for i in np.linspace(0.4, 0.7, 10)]

plt.figure(figsize=(12, 5))

# Subplot 1: Financial Market - Stock A
plt.subplot(1, 2, 1)
plt.bar(
    adjusted_months[:4],
    stock_trend_a[:4],
    color=["#0a74da", "#f39c12", "#2ecc71", "#8e44ad"],
)
plt.bar(adjusted_months[4:], stock_trend_a[4:], color=stock_colors_a)
plt.bar(adjusted_months[4:], trend_projection[0], width=0.5, color=stock_colors_b)
plt.title(title, y=-0.3)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline, linestyle="dotted", color="black")

# Subplot 2: Financial Market - Stock B
plt.subplot(1, 2, 2)
plt.bar(
    adjusted_months[:4],
    stock_trend_b[:4],
    color=["#0a74da", "#f39c12", "#2ecc71", "#8e44ad"],
)
plt.bar(adjusted_months[4:], stock_trend_b[4:], color=stock_colors_a)
plt.bar(adjusted_months[4:], trend_projection[1], width=0.5, color=stock_colors_b)
plt.title(title2, y=-0.3)
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.ylim(ylim2)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline2, linestyle="dotted", color="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("HR_34.pdf", bbox_inches="tight")
