

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate player names (as angles for uniform distribution)
player_ids = np.linspace(0, 2 * np.pi, 120)

# Generate performance metrics with random noise to simulate variability
performance_metrics = 75 + 10 * np.random.randn(120)

# Calculate the x and y coordinates using polar to cartesian transformation
x = performance_metrics * np.cos(player_ids)
y = performance_metrics * np.sin(player_ids)

# Calculate a custom metric for coloring (derived metric e.g., overall performance indicator)
overall_performance = np.abs(x * y)
normalized_performance = (overall_performance - np.min(overall_performance)) / (np.max(overall_performance) - np.min(overall_performance))

# Text labels for title, axis labels, etc.
title = "Performance Metrics of Basketball Players"
xlabel = "X Coordinate"
ylabel = "Y Coordinate"
legendlabel = "Performance Indicator"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating a custom linear color map from light green to dark green based on these new normalized performances
colors = [plt.cm.Greens(performance) for performance in normalized_performance]

# Set the figure size for better visibility
plt.figure(figsize=(8, 8))

# Plot the points with varying sizes and colors
plt.scatter(x, y, c=colors, s=100, edgecolor="black", linewidth=0.5)

# Set the aspect of the plot to be equal
plt.axis("equal")

# Add axis lines
plt.axhline(0, color="gray", linewidth=0.5)
plt.axvline(0, color="gray", linewidth=0.5)

# Add title and axis labels
plt.title(title, fontsize=14)
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)

# Add tick labels
plt.xticks([])
plt.yticks([])

# Add a colorbar for performance indicator
sc = plt.scatter(x, y, c=normalized_performance, cmap="Greens")
cb = plt.colorbar(sc)
cb.set_label(legendlabel, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_40.pdf", bbox_inches="tight")

