
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulated data for E-commerce product sales over time
time = np.linspace(0, 100, 100)
sales_electronics = 500 + 20 * np.sin(time / 10)
sales_clothing = 450 + 18 * np.cos(time / 15)
sales_home_kitchen = 400 + 25 * np.sin(time / 20)
sales_books = 350 + 15 * np.cos(time / 25)
sales_others = 300 + 10 * np.sin(time / 30)

E = np.random.rand(2, 17) * 30
EM = np.random.rand(4, 17) * 25
LM = np.random.rand(5, 17) * 20
LA = np.random.rand(4, 17) * 15
NA = np.random.rand(2, 17) * 10
E = [sorted(e1, reverse=True) for e1 in E]
EM = [sorted(em1, reverse=True) for em1 in EM]
LM = [sorted(lm1) for lm1 in LM]
NA = [sorted(na1) for na1 in NA]

xlabel = "Time (Days)"
ylabel = "Sales Volume"
title = "Product Sales Over Time"
baseline = 0
labels = ["Electronics", "Clothing", "Home & Kitchen", "Books", "Others"]
textheight = 16.5
xlabel2 = "Items(C)"
ylabel2 = "Sales Volume"
title2 = "Sales Volume Distribution per Category"
plotlabels = ["Electronics", "Clothing", "Home & Kitchen", "Books", "Others"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(10, 5))

colors = ["navy", "dodgerblue", "grey", "limegreen", "crimson"]

# Create the left plot (Product Sales Over Time)
plt.subplot(1, 2, 1)
plt.plot(time, sales_electronics, label=plotlabels[0], color=colors[0], linestyle='-', linewidth=2)
plt.plot(time, sales_clothing, label=plotlabels[1], color=colors[1], linestyle='--', linewidth=2)
plt.plot(time, sales_home_kitchen, label=plotlabels[2], color=colors[2], linestyle='-.', linewidth=2)
plt.plot(time, sales_books, label=plotlabels[3], color=colors[3], linestyle=':', linewidth=2)
plt.plot(time, sales_others, label=plotlabels[4], color=colors[4], linestyle='-', linewidth=2)

plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Create the right plot (Sales Volume Distribution per Category)
plt.subplot(1, 2, 2)

for index, values in enumerate([E, EM, LM, LA, NA]):
    for i in range(len(values)):
        plt.scatter(
            [baseline + i] * len(values[i]),
            range(len(values[i])),
            s=values[i],
            c=colors[index],
            alpha=0.7,
            edgecolors='w',
            linewidth=0.5
        )
    plt.text(baseline + len(values) / 2, textheight, labels[index], ha='center', fontsize=8, color='black')
    baseline = baseline + len(values)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

plt.xticks([])
plt.yticks([])
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.title(title2, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("HR_46.pdf", bbox_inches="tight")
