
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Parallelogram boundary points representing weather stations
boundary_points = np.array([[10, 20], [30, 20], [35, 40], [15, 40]])

# Simulate data for different weather statistics
data_temp_station1 = np.random.normal(loc=25, scale=5, size=(250, 2))  # Temperature Station 1
data_temp_station2 = np.random.normal(loc=20, scale=3, size=(250, 2))  # Temperature Station 2
data_precipitation = np.random.normal(loc=15, scale=4, size=(250, 2))   # Precipitation Data

# Labels and configuration
ylabel = [
    "Avg Temp Station 1 (°C)",
    "Avg Temp Station 2 (°C)",
    "Avg Precipitation (mm)",
]
xlabel = "Monthly Data"
labels = ["P1", "P2", "P3", "P4"]
xlim = [5, 40]
ylim = [10, 45]
legendtitle = "num. of points = {}"
title = "Monthly Weather Data from Different Stations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(12, 5))

# Use new colors
colors = ["#FF9999", "#66B2FF", "#99FF99"]
boundary_color = "#FFCC99"

# Create subplots
for i, (data, mode_color) in enumerate(zip([data_temp_station1, data_temp_station2, data_precipitation], colors), 1):
    ax = fig.add_subplot(1, 3, i)
    # Fill the parallelogram with a new color
    ax.fill(boundary_points[:, 0], boundary_points[:, 1], color=boundary_color, alpha=0.5)
    ax.set_xlim(xlim)
    ax.set_ylim(ylim)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel[i - 1])
    if i != 1:
        ax.set_yticks([])

    for point, label in zip(boundary_points, labels):
        ax.text(point[0] + 0.1, point[1] + 0.1, label, color="black", fontsize=8)
    
    scatter = ax.scatter(data[:, 0], data[:, 1], color=mode_color, s=1)
    ax.legend([scatter], [legendtitle.format(len(data))], loc="upper right")
    ax.plot(
        np.append(boundary_points[:, 0], boundary_points[0, 0]),
        np.append(boundary_points[:, 1], boundary_points[0, 1]),
        color="blue",
    )

fig.suptitle(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("HR_47.pdf", bbox_inches="tight")
