

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
flops_per_byte = [2010, 2020] 
flops = [300, 700] 

# Points
points_x = [2011, 2013, 2015, 2017, 2019, 2021] 
points_y = [320, 340, 360, 400, 430, 500] 
labels = [
    "Region A",
    "Region B",
    "Region C",
    "Region D",
    "Region E",
    "Region F",
]

markers = ["o", "s", "v", "^", "d", "<"]
axlines = [
    [[2010, 2025], [700, 700]],
    [[2010, 2025], [600, 600]],
    [[2010, 2025], [500, 500]],
]
x_fill = [2010, 2020, 2025, 2025]  # x goes from 2010 to 2025
y_fill_top = [
    300,
    700,
    700,
    700,
]  # y follows the line segment, then the horizontal line, and back to the start
y_fill_bottom = [
    200,
    200,
    200,
    200,
]  # y is constant at 200 for the bottom boundary
xlabel = "Year"
ylabel = "Average Property Price (in $1000s)"
title = "Real Estate Market Analysis"
xlim = [2010, 2025]
ylim = [200, 800]
textlabels = ["Market Peak", "Expected Trend", "Historical Data", "Average"]
textposition = [
    [2011, 320],
    [2024, 710],
    [2024, 610],
    [2024, 510],
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))
colors = ["darkgreen", "magenta", "navy", "coral", "teal", "gold"]
# Plot the trend line
ax.plot(flops_per_byte, flops, color="black", linewidth=1.5)
ax.plot(axlines[0][0], axlines[0][1], color="black", linestyle="--", linewidth=0.8)
ax.plot(axlines[1][0], axlines[1][1], color="black", linestyle="--", linewidth=0.8)
ax.plot(axlines[2][0], axlines[2][1], color="black", linestyle="--", linewidth=0.8)

ax.fill_between(x_fill, y_fill_top, y_fill_bottom, color="lightblue", alpha=0.5, 
linewidth=0)

# Add text annotations
for idx, text in enumerate(textlabels):
    ax.text(
        textposition[idx][0],
        textposition[idx][1],
        text,
        rotation=0,
        verticalalignment="center",
        fontsize=10,
        backgroundcolor='w'
    )

# Plot the points
for x, y, label, color, marker in zip(points_x, points_y, labels, colors, markers):
    ax.plot(x, y, label=label, color=color, marker=marker, linestyle="None", markersize=10)

# Set scale to linear
ax.set_xscale("linear")
ax.set_yscale("linear")

# Set labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Set limits
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Add legend
ax.legend(fontsize=10, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_57.pdf", bbox_inches="tight")

