
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
gdp_growth_rate = [0.5, 10]  # Placeholder for x-axis data range
unemployment_rate = [2, 25]  # Placeholder for y-axis data range

# Points: Simulated economic data
points_x = [1, 2, 3, 4, 5, 6]
points_y = [5, 6.5, 4.3, 7.8, 3.2, 2.8]
labels = [
    "Q1 2021",
    "Q2 2021",
    "Q3 2021",
    "Q4 2021",
    "Q1 2022",
    "Q2 2022",
]

markers = ["o", "o", "o", "^", "s", "d"]
axlines = [
    [[0.5, 15], [20, 20]],
    [[0.5, 15], [10, 10]],
    [[0.5, 15], [5, 5]],
]

x_fill = [0.5, 10, 15, 15]  
y_fill_top = [2, 25, 25, 25] 
y_fill_bottom = [1, 1, 1, 1]  

xlabel = "GDP Growth Rate (%)"
ylabel = "Unemployment Rate (%)"
xlim = [0.5, 15]
ylim = [1, 25]

textlabels = ["High Growth", "Moderate Growth", "Stagnation", "Recession"]
textposition = [[1, 6], [14, 22], [14, 13], [14, 3]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
colors = ["forestgreen", "limegreen", "palegreen", "firebrick", "orangered", "lightcoral"]
fig, ax = plt.subplots(figsize=(8, 7))

# Plot the roofline model
ax.plot(gdp_growth_rate, unemployment_rate, color="black")
ax.plot(axlines[0][0], axlines[0][1], color="black", linestyle="--")
ax.plot(axlines[1][0], axlines[1][1], color="black", linestyle=":")
ax.plot(axlines[2][0], axlines[2][1], color="black", linestyle="-.")

ax.fill_between(x_fill, y_fill_top, y_fill_bottom, color="lightblue", alpha=0.3)

# Add text annotations
ax.text(
    textposition[0][0],
    textposition[0][1],
    textlabels[0],
    rotation=30,
    verticalalignment="center",
)
ax.text(
    textposition[1][0],
    textposition[1][1],
    textlabels[1],
    rotation=0,
    va="bottom",
    ha="right",
)
ax.text(
    textposition[2][0],
    textposition[2][1],
    textlabels[2],
    rotation=0,
    va="bottom",
    ha="right",
)
ax.text(
    textposition[3][0],
    textposition[3][1],
    textlabels[3],
    rotation=0,
    va="bottom",
    ha="right",
)

# Plot the points
for x, y, label, color, marker in zip(points_x, points_y, labels, colors, markers):
    ax.plot(x, y, label=label, color=color, marker=marker, linestyle="--", markersize=10)

# Set scale to log
ax.set_xscale("log")
ax.set_yscale("log")

# Set labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set limits
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.grid(True)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_58.pdf", bbox_inches="tight")
