
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib_venn import venn2

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set labels and data for Venn diagram
set_labels = ("Law Conference A", "Law Conference B")
data = (45, 25, 30)

title= "Overlap of Participants between Two Law Conferences"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customize the colors and edge styles
# Set the figure size
plt.figure(figsize=(8, 6))

# Create a Venn diagram with new data
venn = venn2(subsets=data, set_labels=set_labels)
# Modify titles and labels
plt.title(title, fontsize=14)

venn.get_patch_by_id("10").set_color("lavender")
venn.get_patch_by_id("10").set_edgecolor("indigo")
venn.get_patch_by_id("10").set_linestyle("dotted")
venn.get_patch_by_id("01").set_color("mistyrose")
venn.get_patch_by_id("01").set_edgecolor("crimson")
venn.get_patch_by_id("01").set_linestyle("dashdot")
venn.get_patch_by_id("11").set_color("lightblue")
venn.get_patch_by_id("11").set_edgecolor("navy")
venn.get_patch_by_id("11").set_linestyle("solid")

# Remove axis
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_63.pdf", bbox_inches="tight")
