# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib_venn import venn2

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Prepare data for Venn Diagram
# Using transportation metrics: Cars (A), Bicycles (B), and their overlap
set_labels = ("Cars", "Bicycles")
subsets = (40, 35, 15)  # New example values

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size first, then create a Venn diagram
plt.figure(figsize=(8, 6))

# Create a Venn diagram with the given data
venn = venn2(subsets=subsets, set_labels=set_labels)

# Customize the colors and edge styles for better visual representation
venn.get_patch_by_id("10").set_color("skyblue")
venn.get_patch_by_id("10").set_edgecolor("blue")
venn.get_patch_by_id("10").set_linestyle("solid")
venn.get_patch_by_id("01").set_color("lightgreen")
venn.get_patch_by_id("01").set_edgecolor("green")
venn.get_patch_by_id("01").set_linestyle("solid")
venn.get_patch_by_id("11").set_color("lightgrey")
venn.get_patch_by_id("11").set_edgecolor("black")
venn.get_patch_by_id("11").set_linestyle("solid")

# Customize labels (if needed)
#for label in venn.set_labels:
#    label.set_fontsize(14)
#for label in venn.subset_labels:
#    label.set_fontsize(12)

# Remove axis for neat visualization
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_64.pdf", bbox_inches="tight")

