

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Placeholder data
m_values = np.linspace(1, 50, 10)
pop_small_species = np.exp(0.05 * m_values)
pop_medium_species = np.exp(0.1 * m_values + 1)  # Medium species, higher population
pop_large_species = np.exp(0.15 * m_values + 2)  # Large species, even higher population
pop_massive_species = np.exp(0.2 * m_values + 3)  # Massive species, highest population

# Create error bands
pop_small_species_err = pop_small_species * 0.3
pop_medium_species_err = pop_medium_species * 0.4
pop_large_species_err = pop_large_species * 0.5
pop_massive_species_err = pop_massive_species * 0.6

xlabel = "Time (Years)"
ylabels = [
    "Average Population Size",
    "Population Deviation",
]
xlim = [1, 60]
ylim = [1e1, 1e6]
title = "Population Growth Analysis"
suptitle = "Species Population Dynamics Over Time"
legendlabels = ["Small Species", "Medium Species", "Large Species", "Massive Species"]
title=["Average Population Size","Population Deviation"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified size (width, height)
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

color_darkblue = "darkblue"
color_darkgreen = "darkgreen"
color_darkred = "darkred"
color_darkorange = "darkorange"
alpha_value = 0.2

# Plot data and curves for the left subplot
ax1.plot(m_values, pop_small_species, "o", color=color_darkblue, label=legendlabels[0])
ax1.fill_between(
    m_values,
    pop_small_species - pop_small_species_err,
    pop_small_species + pop_small_species_err,
    color=color_darkblue,
    alpha=alpha_value,
)
# Fit and plot a line
coeffs = np.polyfit(np.log(m_values), np.log(pop_small_species), 2)
fit_func = np.poly1d(coeffs)
ax1.plot(m_values, np.exp(fit_func(np.log(m_values))), "k--")

ax1.plot(m_values, pop_medium_species, "s", color=color_darkgreen, label=legendlabels[1])
ax1.fill_between(
    m_values,
    pop_medium_species - pop_medium_species_err,
    pop_medium_species + pop_medium_species_err,
    color=color_darkgreen,
    alpha=alpha_value,
)
# Fit and plot a line
coeffs = np.polyfit(np.log(m_values), np.log(pop_medium_species), 2)
fit_func = np.poly1d(coeffs)
ax1.plot(m_values, np.exp(fit_func(np.log(m_values))), "k--")

ax1.set_xscale("log")
ax1.set_yscale("log")
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabels[0])
ax1.set_title(title[0])

# Plot data and curves for the right subplot
ax2.plot(m_values, pop_small_species, "o", color=color_darkblue, label=legendlabels[0])
ax2.fill_between(
    m_values,
    pop_small_species - pop_small_species_err,
    pop_small_species + pop_small_species_err,
    color=color_darkblue,
    alpha=alpha_value,
)
# Fit and plot a line
coeffs = np.polyfit(np.log(m_values), np.log(pop_small_species), 2)
fit_func = np.poly1d(coeffs)
ax2.plot(m_values, np.exp(fit_func(np.log(m_values))), "k--")

ax2.plot(m_values, pop_medium_species, "s", color=color_darkgreen, label=legendlabels[1])
ax2.fill_between(
    m_values,
    pop_medium_species - pop_medium_species_err,
    pop_medium_species + pop_medium_species_err,
    color=color_darkgreen,
    alpha=alpha_value,
)
# Fit and plot a line
coeffs = np.polyfit(np.log(m_values), np.log(pop_medium_species), 2)
fit_func = np.poly1d(coeffs)
ax2.plot(m_values, np.exp(fit_func(np.log(m_values))), "k--")

ax2.plot(m_values, pop_large_species, "d", color=color_darkred, label=legendlabels[2])
ax2.fill_between(
    m_values,
    pop_large_species - pop_large_species_err,
    pop_large_species + pop_large_species_err,
    color=color_darkred,
    alpha=alpha_value,
)
# Fit and plot a line
coeffs = np.polyfit(np.log(m_values), np.log(pop_large_species), 2)
fit_func = np.poly1d(coeffs)
ax2.plot(m_values, np.exp(fit_func(np.log(m_values))), "k--")

ax2.plot(m_values, pop_massive_species, "^", color=color_darkorange, label=legendlabels[3])
ax2.fill_between(
    m_values,
    pop_massive_species - pop_massive_species_err,
    pop_massive_species + pop_massive_species_err,
    color=color_darkorange,
    alpha=alpha_value,
)
# Fit and plot a line
coeffs = np.polyfit(np.log(m_values), np.log(pop_massive_species), 2)
fit_func = np.poly1d(coeffs)
ax2.plot(m_values, np.exp(fit_func(np.log(m_values))), "k--")

ax2.set_xlim(xlim)
ax2.set_ylim(ylim)
ax2.set_xscale("log")
ax2.set_yscale("log")
ax2.set_xlabel(xlabel)
ax2.set_ylabel(ylabels[1])
ax2.set_title(title[1])
ax2.legend(frameon=True)

fig.suptitle(suptitle, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("HR_69.pdf", bbox_inches="tight")

