

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define labels and numpy arrays for the temperature data
years = ["2018", "2019", "2020", "2021", "2022"]
cityA_temp_changes = np.array([0.2, -0.3, 1.1, 0.6, -0.1])
cityB_temp_changes = np.array([-0.4, 0.5, -1.2, 0.3, 0.8])

# Labels and Plot Types
bar_labels = ["City A", "City B"]

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Temperature Change (°C)"
ylim_values = [-2, 2]
title = "Annual Average Temperature Changes (2018-2022)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
def hat_graph(ax, xlabels, values, group_labels):
    def label_bars(heights, rects):
        """Attach a text label on top of each bar."""
        for height, rect in zip(heights, rects):
            ax.annotate(
                f"{height:.1f}°C",
                xy=(rect.get_x() + rect.get_width() / 2, height),
                xytext=(0, 4),  # 4 points vertical offset.
                textcoords="offset points",
                ha="center",
                va="bottom",
            )

    values = np.asarray(values)
    x = np.arange(values.shape[1])
    ax.set_xticks(x, labels=xlabels)
    spacing = 0.3  # spacing between groups
    width = (1 - spacing) / values.shape[0]
    heights0 = values[0]
    for i, (heights, group_label) in enumerate(zip(values, group_labels)):
        style = (
            {"fill": False, "edgecolor": "#2a9d8f", "hatch": "///"}
            if i == 0
            else {"edgecolor": "#2a9d8f", "color": "#264653"}
        )
        rects = ax.bar(
            x - spacing / 2 + i * width,
            heights - heights0,
            width,
            bottom=heights0,
            label=group_label,
            **style,
        )
        label_bars(heights, rects)

fig, ax = plt.subplots(figsize=(8, 5))
hat_graph(ax, years, [cityA_temp_changes, cityB_temp_changes], bar_labels)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_ylim(ylim_values)
ax.set_title(title)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("HR_80.pdf", bbox_inches="tight")

