

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data formatted as (start_year, duration_years)
broken_barh_datax1 = [(2000, 5), (2010, 3), (2020, 4)]
broken_barh_datay1 = (10, 9)
broken_barh_datax2 = [(2002, 2), (2011, 4)]
broken_barh_datay2 = (20, 9)
broken_barh_datax3 = [(2005, 6), (2015, 2)]
broken_barh_datay3 = (30, 9)
broken_barh_datax4 = [(2008, 3), (2012, 5), (2021, 3)]
broken_barh_datay4 = (40, 9)

# Labels and text for chart
labels = ["Warm Period", "Cold Spell", "Moderate Temperature", "Heatwave"]
datalabels = ["City A", "City B", "City C", "City D"]
yticks = [15, 25, 35, 45]
ylim = [5, 55]
xlim = [1999, 2025]
xlabel = "Years"
annotations = "Significant temperature rise"
annotatestart = (2010, 25)
annotateend = (0.7, 0.8)
title = "Temperature Trends Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
facecolors = ["#82b74b", "#d9534f", "#f0ad4e", "#5bc0de"]

# Horizontal bar plot with gaps to show different temperature phases
fig, ax = plt.subplots(figsize=(10, 6))
ax.broken_barh(
    broken_barh_datax1, broken_barh_datay1, facecolors=facecolors[0], label=labels[0]
)
ax.broken_barh(
    broken_barh_datax2, broken_barh_datay2, facecolors=facecolors[1], label=labels[1]
)
ax.broken_barh(
    broken_barh_datax3, broken_barh_datay3, facecolors=facecolors[2], label=labels[2]
)
ax.broken_barh(
    broken_barh_datax4,
    broken_barh_datay4,
    facecolors=facecolors,
    label=labels[3],
)

ax.set_ylim(ylim)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel)
ax.set_yticks(yticks, labels=datalabels)  # More descriptive labels
ax.grid(True, linestyle='--', linewidth=0.5)  # Make grid lines visible with a dashed line
ax.annotate(
    annotations,
    annotatestart,
    xytext=annotateend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=12,
    horizontalalignment="right",
    verticalalignment="top",
)

# Title and legend
ax.set_title(title, fontsize=14, fontweight='bold')
ax.legend(loc="lower right", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_86.pdf", bbox_inches="tight")

