

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

number_of_bins = 40

# Example of test scores in three subjects (out of 100)
number_of_data_points = 387
labels = ["Mathematics", "Science", "Literature"]
data_sets = [
    np.random.normal(70, 10, number_of_data_points),  # Math scores
    np.random.normal(65, 15, number_of_data_points),  # Science scores
    np.random.normal(75, 12, number_of_data_points)   # Literature scores
]

# The bin_edges are the same for all of the histograms
hist_range = (np.min(data_sets), np.max(data_sets))
bin_edges = np.linspace(hist_range[0], hist_range[1], number_of_bins + 1)
centers = bin_edges[:-1] + np.diff(bin_edges) / 2
xlabel = "Scores"
ylabel = "Frequency"
title = "Distribution of Test Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Cycle through and plot each histogram
# Computed quantities to aid plotting
colors = ["#8D6E63", "#FFB74D", "#81C784"]  # Earth-tone colors
binned_data_sets = [
    np.histogram(d, range=hist_range, bins=number_of_bins)[0] for d in data_sets
]
binned_maximums = np.max(binned_data_sets, axis=1)
x_locations = np.arange(0, sum(binned_maximums), np.max(binned_maximums))

fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size for better readability
for x_loc, binned_data, color in zip(x_locations, binned_data_sets, colors):
    lefts = x_loc - 0.5 * binned_data
    ax.barh(
        centers, binned_data, height=np.diff(bin_edges), left=lefts, color=color, edgecolor='black'
    )

# Set the x-axis labels
ax.set_xticks(x_locations)
ax.set_xticklabels(labels, fontsize=12)

# Set labels and title with specific names
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_91.pdf", bbox_inches="tight")

