

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm
from matplotlib.image import NonUniformImage

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
interp = "nearest"

# Simulated stock prices and trading volumes:
dates = np.linspace(1, 100, 100)  # Representing days
stocks = np.linspace(100, 200, 100)  # Representing stock prices
volumes = np.sin(dates/10) * 50 + 100  # Simulated trading volumes

# Financial data using some arbitrary functions:
D, S = np.meshgrid(dates, stocks)
Z = np.log(S * D + 1)

# Text labels
suptitle = "Financial Data Visualization"
xlim = [[1, 100], [1, 100], [1, 100], [1, 100]]
ylim = [[100, 200], [100, 200], [100, 200], [100, 200]]
xlabel = "Days"
ylabel = "Stock Price"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(nrows=2, ncols=2, layout="constrained", figsize=(10, 8))
fig.suptitle(suptitle, fontsize="x-large")
for i, ax in enumerate(axs.flat):
    if i < 2:
        interp = "nearest"
    else:
        interp = "bilinear"
    
    im = NonUniformImage(
        ax,
        interpolation=interp,
        extent=(xlim[i][0], xlim[i][1], ylim[i][0], ylim[i][1]),
        cmap=cm.terrain,
    )
    im.set_data(dates, stocks, Z)
    ax.add_image(im)
    ax.set_xlim(xlim[i])
    ax.set_ylim(ylim[i])
    ax.set_title(f"Interpolation: {interp}")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_99.pdf", bbox_inches="tight")
