
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for Sales Performance and Customer Satisfaction
x_electronics = np.random.normal(10, 2, 15)
y_electronics = np.random.normal(20, 5, 15)
x_furniture = np.random.normal(5, 2, 10)
y_furniture = np.random.normal(15, 4, 10)
x_clothing = np.random.normal(0, 2, 10)
y_clothing = np.random.normal(10, 3, 10)

x_sales_total = np.concatenate([x_electronics, x_furniture, x_clothing])
y_satisfaction_total = np.concatenate([y_electronics, y_furniture, y_clothing])

xlabel = "Δ Sales (%)"
ylabel = "Δ Customer Satisfaction (%)"
ax1xlim = [-5, 15]
ax1ylim = [0, 30]
ax2xlim = [-2, 8]
ax2ylim = [0, 20]

diffline1 = [[0, 0], [-5, 15], [0, 30]]
diffline2 = [[0, 0], [-2, 8], [0, 20]]
annotaterecx1 = [-2, 8]
annotaterecy1 = [0, 20]
plotup1 = [-2, 20]
plotdown1 = [-2, 0]

title = "Impact of Sales Performance on Customer Satisfaction"
subtitle1 = "Overview of Various Product Categories"
subtitle2 = "Detailed View of Selected Categories"
legendlabels = ["Electronics", "Furniture", "Clothing"]
connect_line_color = "brown"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
fig.suptitle(title, fontsize=14)

# Scatter plots
ax1.scatter(x_electronics, y_electronics, marker="^", color="saddlebrown", label=legendlabels[0])
ax1.scatter(x_furniture, y_furniture, marker="v", color="goldenrod", label=legendlabels[1])
ax1.scatter(x_clothing, y_clothing, marker="D", color="darkgreen", label=legendlabels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="lightcoral", alpha=0.3)
ax1.fill_betweenx(y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="palegreen", alpha=0.3)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=0.5)
ax1.plot(diffline1[0], diffline1[2], color="black", lw=0.5)

ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[1], annotaterecy1[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[0]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[0]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotaterecx1[1], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=0.5,
)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(subtitle1)
ax1.legend()
ax1.grid(True, which="both", linestyle="--", lw=0.5)

# Scatter plots
ax2.scatter(x_electronics, y_electronics, marker="^", color="saddlebrown")
ax2.scatter(x_furniture, y_furniture, marker="v", color="goldenrod")
ax2.scatter(x_clothing, y_clothing, marker="D", color="darkgreen")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="lightcoral", alpha=0.3)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="palegreen", alpha=0.3)
# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=0.5)
ax2.plot(diffline2[0], diffline2[2], color="black", lw=0.5)
ax2.set_title(subtitle2)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color=connect_line_color
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color=connect_line_color,
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("PIP_22.pdf", bbox_inches="tight")
