

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Climate data simulation
# Average Temperature, Rainfall, and Carbon Emission for different months
x_temp = np.random.normal(15, 5, 10)
y_temp = np.random.normal(100, 20, 10)
x_temp_additional = np.random.normal(25, 5, 10)
y_temp_additional = np.random.normal(150, 20, 10)
x_temp_total = np.concatenate([x_temp, x_temp_additional])
y_temp_total = np.concatenate([y_temp, y_temp_additional])

# Rainfall data
x_rainfall = np.random.normal(10, 2, 5)
y_rainfall = np.random.normal(80, 10, 5)

# Carbon Emission data
x_emission = np.random.normal(12, 3, 5)
y_emission = np.random.normal(90, 15, 5)

# Labels and limits
xlabel = "Average Temperature (°C)"
ylabel = "Rainfall (mm)"
title = "Climate Data Visualization"
legendlabels = ["Temperature", "Rainfall", "Carbon Emission"]

ax1xlim = [0, 40]
ax1ylim = [50, 200]
diffline1 = [[0, 0], [0, 40], [50, 200]]
diffline2 = [[0, 0], [10, 20], [70, 100]]
annotaterecx1 = [10, 20]
annotaterecy1 = [60, 100]
ax2xlim = [5, 30]
ax2ylim = [60, 100]
plotup1 = [10, 100]
plotdown1 = [10, 60]
suptitle="Climate Data Overview"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors
temp_color = "#1f77b4"
rainfall_color = "#ff7f0e"
emission_color = "#2ca02c"

# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
# Scatter plots
ax1.scatter(x_temp_total, y_temp_total, marker="P", color=temp_color, label=legendlabels[0])
ax1.scatter(x_rainfall, y_rainfall, marker="X", color=rainfall_color, label=legendlabels[1])
ax1.scatter(x_emission, y_emission, marker="o", color=emission_color, label=legendlabels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="red", alpha=0.1)
ax1.fill_betweenx(y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="blue", alpha=0.1)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", linestyle='dashdot', lw=0.7)
ax1.plot(diffline1[0], diffline1[2], color="black", linestyle='dashdot', lw=0.7)

ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[1], annotaterecy1[1]], color="black", linestyle='dotted', lw=0.7)
ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[0]], color="black", linestyle='dotted', lw=0.7)
ax1.plot([annotaterecx1[0], annotaterecx1[0]], [annotaterecy1[0], annotaterecy1[1]], color="black", linestyle='dotted', lw=0.7)
ax1.plot([annotaterecx1[1], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[1]], color="black", linestyle='dotted', lw=0.7)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc='upper left')

# Scatter plots
ax2.scatter(x_temp_total, y_temp_total, marker="P", color=temp_color, label=legendlabels[0])
ax2.scatter(x_rainfall, y_rainfall, marker="X", color=rainfall_color, label=legendlabels[1])
ax2.scatter(x_emission, y_emission, marker="o", color=emission_color, label=legendlabels[2])

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="red", alpha=0.1)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="blue", alpha=0.1)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", linestyle='dashdot', lw=0.7)
ax2.plot(diffline2[0], diffline2[2], color="black", linestyle='dashdot', lw=0.7)
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.legend(loc='upper left')

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(plt.Line2D((main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"))
fig.add_artist(plt.Line2D((main_plot_down[0], inset_down[0]), (main_plot_down[1], inset_down[1]), color="gray"))

# ===================
# Part 4: Saving Output
# ===================
plt.suptitle(suptitle)
plt.tight_layout()
plt.savefig("PIP_23.pdf", bbox_inches="tight")
