

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
x = ["Jan", "Feb", "Mar", "Apr"]
y1 = [5, 7, 10, 15]  # City A
y2 = [3, 5, 12, 18]  # City B
y3 = [0, 2, 8, 12]   # City C
y4 = [10, 12, 15, 20]  # City D
labels = ["City A", "City B", "City C", "City D"]
insertax1 = [0.3, 0.5, 0.1, 0.3]
insertylim1 = [5, 20]
insertxlim1 = [1.5, 2.5]
insertax2 = [0.8, 0.4, 0.1, 0.3]
insertylim2 = [10, 20]
insertxlim2 = [2.5, 3.5]
xlabel = "Month"
ylabel = "Average Temperature (°C)"
title = "Monthly Average Temperature Across Cities"
insetaxes = [0.50, 0.6, 0.1, 0.3]
arrowend1 = [0.48, 0.75]
arrowend2 = [0.85, 0.75]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))

custom_colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728']

ax.plot(x, y1, color=custom_colors[0], linestyle='-', marker='o', label=labels[0])
ax.plot(x, y2, color=custom_colors[1], linestyle='--', marker='s', label=labels[1])
ax.plot(x, y3, color=custom_colors[2], linestyle='-.', marker='^', label=labels[2])
ax.plot(x, y4, color=custom_colors[3], linestyle=':', marker='D', label=labels[3])

# Create the inset with the zoomed-in view
ax_inset1 = fig.add_axes(insetaxes)
ax_inset1.plot(x, y1, color=custom_colors[0], linestyle='-', marker='o')
ax_inset1.plot(x, y2, color=custom_colors[1], linestyle='--', marker='s')
ax_inset1.plot(x, y3, color=custom_colors[2], linestyle='-.', marker='^')
ax_inset1.plot(x, y4, color=custom_colors[3], linestyle=':', marker='D')
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Create the inset with the zoomed-in view
ax_inset2 = fig.add_axes(insertax2)
ax_inset2.plot(x, y1, color=custom_colors[0], linestyle='-', marker='o')
ax_inset2.plot(x, y2, color=custom_colors[1], linestyle='--', marker='s')
ax_inset2.plot(x, y3, color=custom_colors[2], linestyle='-.', marker='^')
ax_inset2.plot(x, y4, color=custom_colors[3], linestyle=':', marker='D')
ax_inset2.spines["bottom"].set_color("black")
ax_inset2.spines["left"].set_color("black")
ax_inset2.spines["top"].set_color("black")
ax_inset2.spines["right"].set_color("black")
ax_inset2.set_ylim(insertylim2)
ax_inset2.set_xlim(insertxlim2)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)

# Annotate with arrows
ax.annotate(
    "",
    xy=(x[1], y4[1]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.5, shrink=0.01),
)
ax.annotate(
    "",
    xy=(x[3], y4[3]),
    xytext=arrowend2,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.5, shrink=0.01),
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("PIP_28.pdf", bbox_inches="tight")

