
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
x = ["January", "February", "March", "April"]
y1 = [25, 47, 32, 58]  # Action
y2 = [36, 28, 54, 40]  # Comedy
y3 = [22, 55, 40, 35]  # Drama
y4 = [15, 33, 48, 52]  # Sci-Fi
labels = ["Action", "Comedy", "Drama", "Sci-Fi"]
insertax1 = [0.3, 0.15, 0.2, 0.2]
insertylim1 = [10, 60]
insertxlim1 = [0.5, 1.5]
insertax2 = [0.7, 0.2, 0.2, 0.2]
insertylim2 = [30, 60]
insertxlim2 = [2.5, 3.5]
xlabel = "Month"
ylabel = "Ticket Sales (Thousands)"
title = "Monthly Ticket Sales Trends by Genre"
insetaxes = [0.3, 0.15, 0.2, 0.2]
arrowend1 = [0.3, 0.3]
arrowend2 = [0.75, 0.25]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust figure size to match original image's dimensions

color_action = "#1f77b4"
color_comedy = "#ff7f0e"
color_drama = "#2ca02c"
color_scifi = "#d62728"

ax.plot(x, y1, "o--", color=color_action, label=labels[0])  # Blue: Action
ax.plot(x, y2, "s-.", color=color_comedy, label=labels[1])  # Orange: Comedy
ax.plot(x, y3, "d-", color=color_drama, label=labels[2])  # Green: Drama
ax.plot(x, y4, "v:", color=color_scifi, label=labels[3])  # Red: Sci-Fi

# Create the first inset with the zoomed-in view
ax_inset1 = fig.add_axes(insertax1)
ax_inset1.plot(x, y1, "o--", color=color_action)
ax_inset1.plot(x, y2, "s-.", color=color_comedy)
ax_inset1.plot(x, y3, "d-", color=color_drama)
ax_inset1.plot(x, y4, "v:", color=color_scifi)
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Create the second inset with the zoomed-in view
ax_inset2 = fig.add_axes(insertax2)
ax_inset2.plot(x, y1, "o--", color=color_action)
ax_inset2.plot(x, y2, "s-.", color=color_comedy)
ax_inset2.plot(x, y3, "d-", color=color_drama)
ax_inset2.plot(x, y4, "v:", color=color_scifi)
ax_inset2.spines["bottom"].set_color("black")
ax_inset2.spines["left"].set_color("black")
ax_inset2.spines["top"].set_color("black")
ax_inset2.spines["right"].set_color("black")
ax_inset2.set_ylim(insertylim2)
ax_inset2.set_xlim(insertxlim2)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)

# Annotate with arrows
ax.annotate(
    "",
    xy=(x[1], y4[1]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)
ax.annotate(
    "",
    xy=(x[3], y4[3]),
    xytext=arrowend2,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("PIP_29.pdf", bbox_inches="tight")
