
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate some dummy data for geography
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
average_rainfall = [78, 85, 92, 105, 120, 135, 150, 145, 130, 115, 90, 80]  # Rainfall in mm
average_temperature = [2, 4, 8, 12, 18, 22, 25, 24, 20, 15, 8, 4]  # Temperature in °C
labels = ["Rainfall", "Temperature"]
xmainlabel = "Months"
xmainlim = [-1, 12]
xmainticks = list(range(12))
ymainlabel = "Average Values"
ymainlim = [0, 300]
ymainticks = [0, 50, 100, 150, 200, 250, 300]

xinsetlim = [-0.5, 5]
xinsetticks = list(range(0, 5))
yinsetlim = [0, 200]
yinsetticks = [0, 50, 100, 150, 200]

# Create inset plot with adjusted bar widths and white borders
left, bottom, width, height = [0.15, 0.5, 0.3, 0.3]
mainplotline = [(-1, 70), (4, 70)]
maininsetline = [(0, 0), (4, 0)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.3  # Adjust the bar width
rainfall_color = "#8FBF73"  # Earthy green color
temperature_color = "#C99069"  # Earthy brown color

ax_main.bar(
    xmainticks,
    average_rainfall,
    width=bar_width,
    color=rainfall_color,
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    xmainticks,
    average_temperature,
    width=bar_width,
    color=temperature_color,
    align="center",
    bottom=average_rainfall,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_xticklabels(months)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper right", prop={"size": 16})
ax_main.grid(True, linestyle='--', linewidth=0.5)

ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(
    xmainticks[0:5],
    average_rainfall[0:5],
    width=bar_width,
    color=rainfall_color,
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    xmainticks[0:5],
    average_temperature[0:5],
    width=bar_width,
    color=temperature_color,
    align="center",
    bottom=average_rainfall[0:5],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(xinsetticks)  # Zoom in on the right part of the data
ax_inset.set_xticklabels(months[0:5])
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)
ax_inset.grid(True, linestyle='--', linewidth=0.5)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_30.pdf", bbox_inches="tight")
