

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate some dummy data for "Football Goals" domain
category1 = [
    20, 35, 30, 45, 40, 33, 25, 28, 22, 19, 25
]  # Goals for Forwards
category2 = [
    8,  15, 18, 20, 18, 16, 12, 14, 10, 11,  9
]  # Goals for Midfielders
bins = list(range(1, 12))  # Seasons 1 to 11
labels = ["Forwards", "Midfielders"]
xmainlabel = "Seasons"
xmainlim = [0, 12]
xmainticks = list(range(1, 12))
ymainlabel = "Number of Goals"
ymainlim = [0, 80]
ymainticks = list(range(0, 81, 10))

xinsetlim = [4.5, 8.5]
xinsetticks = [5, 6, 7, 8]
yinsetlim = [0, 60]
yinsetticks = list(range(0, 61, 20))

left, bottom, width, height = [0.5, 0.65, 0.3, 0.3]
mainplotline = [(4.5, 10), (8.5, 10)]
maininsetline = [(5, 0), (8, 0)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.45  # Adjust bar width for better visual separation
ax_main.bar(
    bins,
    category1,
    width=bar_width,
    color="#81C784",  # Greenish color
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    bins,
    category2,
    width=bar_width,
    color="#FFB74D",  # Orange color
    align="center",
    bottom=category1,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper right", prop={"size": 12})
ax_main.grid()

ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(
    bins[4:],  # Only include bins from season 5 onwards
    category1[4:],
    width=bar_width,
    color="#81C784",
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    bins[4:],  # Only include bins from season 5 onwards
    category2[4:],
    width=bar_width,
    color="#FFB74D",
    align="center",
    bottom=category1[4:],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on mid-seasons
ax_inset.set_xticks(xinsetticks)
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)
ax_inset.grid()

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_31.pdf", bbox_inches="tight")
