

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
years = np.arange(2016, 2022)
cases_handled = np.array([120, 150, 130, 160, 190, 210])
clients = np.array([200, 220, 280, 300, 350, 400])
client_satisfaction = np.array([70, 72, 75, 78, 80, 85])  # in percentage

labels = ["Cases Handled", "Clients", "Client Satisfaction"]
xlabel = "Year"
ylabel = "Number / Percentage"
ylim = [0, 450]
yticks = [0, 100, 200, 300, 400]
insetaxes = [0.75, 0.55, 0.2, 0.2]
yinsetlim = [60, 90]
xtickslabels = [str(year) for year in years]
yinsetyticks = [60, 70, 80]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Colors
cases_handled_color = "#2ca02c"
clients_color = "#1f77b4"
client_satisfaction_color = "#ff7f0e"

# Plot the data
ax.plot(years, cases_handled, "o-", label=labels[0], color=cases_handled_color, linewidth=2, markersize=8)
ax.plot(years, clients, "s--", label=labels[1], color=clients_color, linewidth=2, markersize=8)
ax.plot(years, client_satisfaction, "D-.", label=labels[2], color=client_satisfaction_color, linewidth=2, markersize=8)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Adjust y-axis limits
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.set_yticklabels(['0', '100', '200', '300', '400'], fontsize=12)

# Add a legend
ax.legend(labels, loc='upper left', fontsize=12)

# Create an inset axis for the Client Satisfaction data
ax_inset = fig.add_axes(insetaxes)
ax_inset.plot(years, client_satisfaction, "D-.", color=client_satisfaction_color, linewidth=2, markersize=8)

# Adjust y-axis limits for inset
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetyticks)
ax_inset.set_yticklabels(yinsetyticks, fontsize=10)

# Set the same x-axis limits for the inset as the main plot
ax_inset.set_xlim([2017.5,2019.5])
ax_inset.set_xticks([2018,2019])
ax_inset.set_xticklabels(['2018','2019'], fontsize=10)
ax_inset.set_xlabel('Year', fontsize=10)
ax_inset.set_ylabel('Client Satisfaction', fontsize=10)

# Change x-axis tick labels
ax.set_xticks(years)
ax.set_xticklabels(xtickslabels, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_34.pdf", bbox_inches="tight")
