
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
years = np.arange(2015, 2021, 1)
email_usage = np.array([50, 52, 53, 54, 55, 56])
social_media_usage = np.array([30, 35, 40, 45, 50, 55])
phone_call_usage = np.array([45, 43, 42, 40, 38, 37])
messaging_app_usage = np.array([25, 30, 35, 40, 45, 50])

labels = ["Email Usage", "Social Media Usage", "Phone Call Usage", "Messaging App Usage"]
xlabel = "Year"
ylabel = "Usage Percentage (%)"
ylim = [0, 60]
yticks = [0, 10, 20, 30, 40, 50, 60]
insetaxes = [0.55, 0.15, 0.3, 0.25]
yinsetlim = [20, 60]
xtickslabels = [str(year) for year in years]
yinsetyticks = [20, 30, 40, 50, 60]
title = "Communication Platform Usage Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted to match the original image's dimensions

# Plot the data
ax.plot(years, email_usage, "o-", label=labels[0], color="#1f77b4", linewidth=2, markersize=6)
ax.plot(years, social_media_usage, "s--", label=labels[1], color="#ff7f0e", linewidth=2, markersize=6)
ax.plot(years, phone_call_usage, "^:", label=labels[2], color="#2ca02c", linewidth=2, markersize=6)
ax.plot(years, messaging_app_usage, "d-.", label=labels[3], color="#d62728", linewidth=2, markersize=6)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a legend
ax.legend()

# Create an inset axis for the detailed view
ax_inset = fig.add_axes(insetaxes)
ax_inset.plot(years, email_usage, "o-", color="#1f77b4", linewidth=2, markersize=6)
ax_inset.plot(years, social_media_usage, "s--", color="#ff7f0e", linewidth=2, markersize=6)

# Adjust y-axis limits for inset
ax_inset.set_ylim(yinsetlim)

# Set the same x-axis limits for the inset as the main plot
ax_inset.set_xlim(ax.get_xlim())
ax_inset.set_yticks(yinsetyticks)

# Change x-axis tick labels to year notation
ax.set_xticks(years)
ax.set_xticklabels(xtickslabels)
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(xtickslabels)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_35.pdf", bbox_inches="tight")
