
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new sample data for three philosophical clusters
x1 = np.random.normal(4, 1.0, 120)
y1 = np.random.normal(7, 1.2, 120)

x2 = np.random.normal(2, 1.5, 120)
y2 = np.random.normal(3, 1.3, 120)

x3 = np.random.normal(7, 1.4, 120)
y3 = np.random.normal(5, 1.1, 120)

# Text labels and chart parameters
xlabel = "X-axis: Philosophical Dimension 1"
ylabel = "Y-axis: Philosophical Dimension 2"
title = "Distribution of Philosophical Schools"
insetxlim = [1, 5]
insetylim = [6, 8]
insetxticks = [1.0, 3.0, 5.0]
insetyticks = [6.0, 7.0, 8.0]
axesgrid = [0.2, 0.6, 0.2, 0.2]
legend_labels = ["Existentialism", "Empiricism", "Pragmatism"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size and style
fig, ax = plt.subplots(figsize=(8, 8))

# Plot the data with customized colors and markers
ax.scatter(x1, y1, c="#D32F2F", label=legend_labels[0], marker='o', edgecolor='k')
ax.scatter(x2, y2, c="#1976D2", label=legend_labels[1], marker='s', edgecolor='k')
ax.scatter(x3, y3, c="#388E3C", label=legend_labels[2], marker='^', edgecolor='k')

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add the legend with a customized position and frame
ax.legend(loc="upper left", frameon=True)

# Create the inset with zoomed-in view
ax_inset = fig.add_axes(axesgrid)
ax_inset.scatter(x1, y1, c="#D32F2F", label=legend_labels[0], marker='o', edgecolor='k')
ax_inset.scatter(x2, y2, c="#1976D2", label=legend_labels[1], marker='s', edgecolor='k')
ax_inset.scatter(x3, y3, c="#388E3C", label=legend_labels[2], marker='^', edgecolor='k')
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("PIP_44.pdf", bbox_inches="tight")
