
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Legal data for crime rates and years
import numpy as np

np.random.seed(0)
# Crime rates in different years for different regions
crime_rates_region_a = np.random.normal(20, 5, 10)  # Crime rates (Region A)
years_region_a = np.random.randint(2000, 2010, 10)  # Years (Region A)
crime_rates_region_b = np.random.normal(25, 6, 10)  # Crime rates (Region B)
years_region_b = np.random.randint(2000, 2010, 10)  # Years (Region B)
crime_rates_region_ab = np.concatenate([crime_rates_region_a, crime_rates_region_b])
years_region_ab = np.concatenate([years_region_a, years_region_b])

# Crime rates and years for smaller regions
crime_rates_region_c = np.random.normal(22, 4, 5)  # Crime rates (Region C)
years_region_c = np.random.randint(2000, 2010, 5)  # Years (Region C)
crime_rates_region_d = np.random.normal(18, 3, 5)  # Crime rates (Region D)
years_region_d = np.random.randint(2000, 2010, 5)  # Years (Region D)

# Labels and plot limits
xlabel = "Years"
ylabel = "Crime Rates"
title = "Crime Rates vs Years in Different Regions"
suptitle = "Legal Analysis of Crime Rates"
labels = ["Region A & B", "Region C", "Region D"]

ax1_xlim = [1999, 2011]
ax1_ylim = [10, 60]
main_diff_line = [[10, 10], [1999, 2011], [10, 60]]
inset_diff_line = [[10, 10], [2002, 2008], [15, 50]]
annotation_rect_x = [2002, 2008]
annotation_rect_y = [15, 50]
ax2_xlim = [2002, 2008]
ax2_ylim = [15, 50]
main_plot_upper = [2002, 50]
main_plot_lower = [2002, 15]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
fig.suptitle(suptitle, fontsize=14)

# Scatter plots
color_region_ab = "mediumseagreen"
color_region_c = "coral"
color_region_d = "royalblue"

ax1.scatter(years_region_ab, crime_rates_region_ab, marker="^", color=color_region_ab, label=labels[0])
ax1.scatter(years_region_c, crime_rates_region_c, marker="o", color=color_region_c, label=labels[1])
ax1.scatter(years_region_d, crime_rates_region_d, marker="s", color=color_region_d, label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[25, ax1_ylim[1]], x1=ax1_xlim[0], x2=2002, color="lightblue", alpha=0.3)
ax1.fill_betweenx(y=[25, ax1_ylim[0]], x1=2002, x2=ax1_xlim[1], color="lightgreen", alpha=0.3)

# Axis limits and aspect ratio
ax1.set_xlim(ax1_xlim)
ax1.set_ylim(ax1_ylim)
ax1.plot(main_diff_line[1], main_diff_line[0], color="black", lw=0.5)
ax1.plot(main_diff_line[0], main_diff_line[2], color="black", lw=0.5)

# Annotation rectangle
ax1.plot([annotation_rect_x[0], annotation_rect_x[1]], [annotation_rect_y[1], annotation_rect_y[1]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[0], annotation_rect_x[1]], [annotation_rect_y[0], annotation_rect_y[0]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[0], annotation_rect_x[0]], [annotation_rect_y[0], annotation_rect_y[1]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[1], annotation_rect_x[1]], [annotation_rect_y[0], annotation_rect_y[1]], color="black", lw=0.5)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title)

# Scatter plots for inset
ax2.scatter(years_region_ab, crime_rates_region_ab, marker="^", color=color_region_ab)
ax2.scatter(years_region_c, crime_rates_region_c, marker="o", color=color_region_c)
ax2.scatter(years_region_d, crime_rates_region_d, marker="s", color=color_region_d)

# Shaded regions for inset
ax2.fill_betweenx(y=[ax2_ylim[1], 25], x1=ax2_xlim[0], x2=2002, color="lightblue", alpha=0.3)
ax2.fill_betweenx(y=[25, ax2_ylim[0]], x1=2002, x2=ax2_xlim[1], color="lightgreen", alpha=0.3)

# Axis limits and aspect ratio for inset
ax2.set_xlim(ax2_xlim)
ax2.set_ylim(ax2_ylim)
ax2.plot(inset_diff_line[1], inset_diff_line[0], color="black", lw=0.5)
ax2.plot(inset_diff_line[0], inset_diff_line[2], color="black", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(main_plot_upper)
ax1_plot_down = ax1.transData.transform_point(main_plot_lower)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(main_plot_upper)
ax2_down = ax2.transData.transform_point(main_plot_lower)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(plt.Line2D((main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"))
fig.add_artist(plt.Line2D((main_plot_down[0], inset_down[0]), (main_plot_down[1], inset_down[1]), color="gray"))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_55.pdf", bbox_inches="tight")
