
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# GDP and Renewable Energy Investment data
np.random.seed(42)
gdp_region_a = np.random.normal(500, 50, 10)  # GDP (Region A)
investment_region_a = np.random.normal(200, 20, 10)  # Renewable Energy Investment (Region A)
gdp_region_b = np.random.normal(700, 70, 10)  # GDP (Region B)
investment_region_b = np.random.normal(300, 30, 10)  # Renewable Energy Investment (Region B)
gdp_region_ab = np.concatenate([gdp_region_a, gdp_region_b])
investment_region_ab = np.concatenate([investment_region_a, investment_region_b])

# Smaller regions
gdp_region_c = np.random.normal(600, 40, 5)  # GDP (Region C)
investment_region_c = np.random.normal(250, 15, 5)  # Renewable Energy Investment (Region C)
gdp_region_d = np.random.normal(550, 35, 5)  # GDP (Region D)
investment_region_d = np.random.normal(270, 18, 5)  # Renewable Energy Investment (Region D)

# Labels and plot limits
xlabel = "GDP (in Billion USD)"
ylabel = "Renewable Energy Investment (in Billion USD)"
title = "GDP vs Renewable Energy Investment"
annotation_text = "Economic Region Highlight"
ax1xlim = [400, 900]
ax1ylim = [150, 350]
main_diff_line = [[150, 150], [400, 900], [150, 350]]
inset_diff_line = [[150, 150], [500, 800], [200, 320]]
annotation_rect_x = [500, 800]
annotation_rect_y = [200, 320]
ax2xlim = [500, 800]
ax2ylim = [200, 320]
main_plot_upper = [500, 320]
main_plot_lower = [500, 200]

labels = ["Region A & B", "Region C", "Region D"]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))
# Scatter plots
ax1.scatter(
    gdp_region_ab, investment_region_ab, marker="^", color="#005ab5", label=labels[0]
)
ax1.scatter(gdp_region_c, investment_region_c, marker="o", color="#d3651e", label=labels[1])
ax1.scatter(gdp_region_d, investment_region_d, marker="s", color="#1ea755", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[200, ax1ylim[1]], x1=ax1xlim[0], x2=650, color="purple", alpha=0.2)
ax1.fill_betweenx(y=[200, ax1ylim[0]], x1=650, x2=ax1xlim[1], color="orange", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(main_diff_line[1], main_diff_line[0], color="gray", lw=0.5)
ax1.plot(main_diff_line[0], main_diff_line[2], color="gray", lw=0.5)

ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[1], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[0]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[0]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[1], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title)

# Scatter plots
ax2.scatter(gdp_region_ab, investment_region_ab, marker="^", color="#005ab5")
ax2.scatter(gdp_region_c, investment_region_c, marker="o", color="#d3651e")
ax2.scatter(gdp_region_d, investment_region_d, marker="s", color="#1ea755")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 200], x1=ax2xlim[0], x2=650, color="purple", alpha=0.2)
ax2.fill_betweenx(y=[200, ax2ylim[0]], x1=650, x2=ax2xlim[1], color="orange", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(inset_diff_line[1], inset_diff_line[0], color="gray", lw=0.5)
ax2.plot(inset_diff_line[0], inset_diff_line[2], color="gray", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(main_plot_upper)
ax1_plot_down = ax1.transData.transform_point(main_plot_lower)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(main_plot_upper)
ax2_down = ax2.transData.transform_point(main_plot_lower)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_56.pdf", bbox_inches="tight")
