
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample political data (approval ratings, economic indicators, and public sentiment levels)
approval_ratings_A = np.random.normal(55, 10, 10)  # Approval ratings for Party A
approval_ratings_B = np.random.normal(45, 12, 10)  # Approval ratings for Party B
gdp_growth_A = np.random.normal(3, 1, 10)  # GDP growth for Party A
gdp_growth_B = np.random.normal(2, 0.8, 10)  # GDP growth for Party B
optimism_A = np.random.normal(60, 15, 10)  # Public optimism levels for Party A
pessimism_B = np.random.normal(40, 10, 10)  # Public pessimism levels for Party B

ratings_total = np.concatenate([approval_ratings_A, approval_ratings_B])
growth_total = np.concatenate([gdp_growth_A, gdp_growth_B])
sentiment_total = np.concatenate([optimism_A, pessimism_B])

xlabel = "Approval Rating (%)"
ylabel = "GDP Growth (%)"
ax1xlim = [20, 100]
ax1ylim = [0, 6]
diffline1 = [[0, 0], [20, 100], [0, 6]]
diffline2 = [[0, 0], [45, 60], [1, 4]]
annotaterecx1 = [45, 60]
annotaterecy1 = [1, 3]
ax2xlim = [45, 60]
ax2ylim = [1, 4]
plotup1 = [50, 3]
plotdown1 = [50, 1]

label = [
    "Approval Ratings for Party A",
    "GDP Growth for Party A",
    "Public Sentiment for Party A",
]
label2 = ["Low Approval Zone", "High Growth Zone"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Scatter plots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
scatter1_color = "darkblue"
scatter2_color = "darkgreen"
scatter3_color = "darkorange"
shade1_color = "red"
shade2_color = "green"
line_color = "black"
annotate_color = "gray"

ax1.scatter(ratings_total, growth_total, marker="^", color=scatter1_color, label=label[0])
ax1.scatter(optimism_A, pessimism_B, marker="o", color=scatter2_color, label=label[1])
ax1.scatter(sentiment_total, growth_total, marker="s", color=scatter3_color, label=label[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color=shade1_color, alpha=0.2, label=label2[0])
ax1.fill_betweenx(y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color=shade2_color, alpha=0.2, label=label2[1])

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color=line_color, lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color=line_color, lw=1, linestyle="--")

ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[1], annotaterecy1[1]], color=line_color, lw=1, linestyle="--")
ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[0]], color=line_color, lw=1, linestyle="--")
ax1.plot([annotaterecx1[0], annotaterecx1[0]], [annotaterecy1[0], annotaterecy1[1]], color=line_color, lw=1, linestyle="--")
ax1.plot([annotaterecx1[1], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[1]], color=line_color, lw=1, linestyle="--")

ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc="upper right")

# Scatter plots for the second axis
ax2.scatter(ratings_total, growth_total, marker="^", color=scatter1_color)
ax2.scatter(optimism_A, pessimism_B, marker="o", color=scatter2_color)
ax2.scatter(sentiment_total, growth_total, marker="s", color=scatter3_color)

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color=shade1_color, alpha=0.2)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color=shade2_color, alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color=line_color, lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color=line_color, lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(plt.Line2D((main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color=annotate_color))
fig.add_artist(plt.Line2D((main_plot_down[0], inset_down[0]), (main_plot_down[1], inset_down[1]), color=annotate_color))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_62.pdf", bbox_inches="tight")
