
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
x = ["Apple", "Google", "Microsoft", "Amazon"]
y1 = [150, 180, 200, 220]  # Year 1 average stock price ($)
y2 = [160, 190, 210, 230]  # Year 2 average stock price ($)
y3 = [170, 200, 220, 240]  # Year 3 average stock price ($)
y4 = [180, 210, 230, 250]  # Year 4 average stock price ($)
labels = ["Year 1", "Year 2", "Year 3", "Year 4"]
insertax1 = [0.6, 0.2, 0.1, 0.3]
insertylim1 = [190, 240]
insertxlim1 = [1.5, 2.5]
insertax2 = [0.88, 0.2, 0.1, 0.2]
insertylim2 = [220, 240]
insertxlim2 = [3.5, 6.5]
xlabel = "Company"
ylabel = "Average Stock Price ($)"
title = "Average Annual Stock Prices of Top Tech Companies"
insetaxes = [0.7, 0.15, 0.1, 0.3]
arrowend1 = [0.75, 0.5]
arrowend2 = [0.93, 0.7]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))

ax.plot(x, y1, color="#FF5733", marker="o", linestyle="-", label=labels[0])
ax.plot(x, y2, color="#33FF57", marker="s", linestyle="--", label=labels[1])
ax.plot(x, y3, color="#3357FF", marker="d", linestyle="-.", label=labels[2])
ax.plot(x, y4, color="#FF33A1", marker="^", linestyle=":", label=labels[3])

# Create the first inset with the zoomed-in view
ax_inset1 = fig.add_axes(insetaxes)
ax_inset1.plot(x, y1, color="#FF5733", marker="o", linestyle="-")
ax_inset1.plot(x, y2, color="#33FF57", marker="s", linestyle="--")
ax_inset1.plot(x, y3, color="#3357FF", marker="d", linestyle="-.")
ax_inset1.plot(x, y4, color="#FF33A1", marker="^", linestyle=":")
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="lower right")
ax.grid(True)
ax.annotate(
    "",
    xy=(x[2], y3[2]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("PIP_63.pdf", bbox_inches="tight")
