
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
x = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
y1 = [30, 32, 35, 40, 45, 50, 55, 54, 49, 43, 36, 32]  # Location A: Average temperatures
y2 = [25, 28, 33, 38, 44, 49, 52, 51, 47, 41, 34, 29]  # Location B
y3 = [20, 22, 27, 33, 39, 45, 48, 47, 43, 38, 30, 24]  # Location C
labels = ["Location A", "Location B", "Location C"]
xlabel = "Month"
ylabel = "Average Temperature (°C)"
title = "Monthly Average Temperatures for Different Locations"
insetaxes = [0.6, 0.5, 0.1, 0.3]
insertax1 = [0.6, 0.2, 0.1, 0.3]
insertylim1 = [20, 55]
insertxlim1 = [3.5, 5.5]
insertax2 = [0.88, 0.7, 0.1, 0.2]
insertylim2 = [35, 55]
insertxlim2 = [2.8, 6.8]
arrowend1 = [0.65, 0.4]
arrowend2 = [0.93, 0.7]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(12, 8))

ax.plot(x, y1, color="#4CAF50", marker="o", linestyle="-", linewidth=2, label=labels[0])
ax.plot(
    x, y2, color="#2196F3", marker="s", linestyle="--", linewidth=2, label=labels[1]
)
ax.plot(
    x, y3, color="#FFC107", marker="^", linestyle="-.", linewidth=2, label=labels[2]
)

# Create the first inset with the zoomed-in view
ax_inset1 = fig.add_axes(insetaxes)
ax_inset1.plot(x, y1, color="#4CAF50", marker="o", linestyle="-")
ax_inset1.plot(x, y2, color="#2196F3", marker="s", linestyle="--")
ax_inset1.plot(x, y3, color="#FFC107", marker="^", linestyle="-.")
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)
ax_inset1.grid(True)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)
ax.annotate(
    "",
    xy=(x[4], y3[4]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)

# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("PIP_64.pdf", bbox_inches="tight")
