
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated Technology Adoption Data for plotting

years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
adoption_social_media = np.array(
    [100, 300, 900, 2700, 5400, 8000]
)  # Exponential growth for Social Media
adoption_smartphones = np.array(
    [150, 450, 1350, 4050, 6000, 7500]
)  # Exponential growth for Smartphones
adoption_online_shopping = np.array(
    [200, 400, 600, 800, 1000, 1200]
)  # Linear growth for Online Shopping
adoption_smart_home = np.array(
    [50, 100, 150, 200, 250, 300]
)  # Linear growth for Smart Home Devices

labels = [
    "Social Media Adoption | Exponential Growth",
    "Smartphone Adoption | Exponential Growth",
    "Online Shopping Adoption | Linear Growth",
    "Smart Home Devices Adoption | Linear Growth",
]
xlabel = "Year"
ylabel = "Number of Users (in Thousands)"
title = "Technology Adoption Trends (2010-2020)"

# Labels and tick mark settings
xticks = years
yticks = np.linspace(0, 8000, 9)
yticklabels = [f"{int(x):,}" for x in yticks]
inset_axes = [0.2, 0.4, 0.25, 0.3]
inset_ylim = [0, 8000]
yticks_inset = np.linspace(0, 8000, 9)
x_years = [f"{int(x)}" for x in years]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data with different styles and colors
ax.plot(
    years, adoption_social_media, "o-", label=labels[0], color="#1f77b4"
)  # Blue for Social Media
ax.plot(
    years, adoption_smartphones, "x--", label=labels[1], color="#2ca02c"
)  # Green for Smartphones
ax.plot(
    years, adoption_online_shopping, "s-", label=labels[2], color="#ff7f0e"
)  # Orange for Online Shopping
ax.plot(
    years, adoption_smart_home, "d--", label=labels[3], color="#d62728"
)  # Red for Smart Home Devices

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits and ticks
ax.set_ylim([0, 8000])
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

# Add a legend
ax.legend()

# Create an inset axis for technology adoption data
ax_inset = fig.add_axes(inset_axes)
ax_inset.plot(years, adoption_social_media, "o-", color="#1f77b4")
ax_inset.plot(years, adoption_smartphones, "x--", color="#2ca02c")

# Adjust y-axis limits for inset
ax_inset.set_ylim(inset_ylim)
ax_inset.set_xlim([2014, 2020])
ax_inset.set_yticks(yticks_inset)

# Change x-axis tick labels to years
ax.set_xticks(years)
ax.set_xticklabels(x_years)
ax_inset.set_xticks([2014, 2016, 2018, 2020])
ax_inset.set_xticklabels([2014, 2016, 2018, 2020])

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_69.pdf", bbox_inches="tight")
