
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
categories = {
    "Laptops": np.random.normal(loc=[10, 70], scale=[2, 10], size=(50, 2)),
    "Smartphones": np.random.normal(loc=[15, 80], scale=[3, 8], size=(50, 2)),
    "Tablets": np.random.normal(loc=[12, 75], scale=[2.5, 9], size=(50, 2)),
    "Smartwatches": np.random.normal(loc=[30, 60], scale=[5, 12], size=(50, 2)),
    "Desktops": np.random.normal(loc=[3, 90], scale=[1, 10], size=(50, 2)),
}

insetaxes = [0.25, 0.10, 0.2, 0.2]
insetxlim = [0, 10]
insetylim = [60, 110]
insetxticks = [0, 10,]
insetyticks = [30, 70,110]
arrowstart = (2, 90)
arrowend = (0.2, 0.2)
annotaterecx = [0, 10]
annotaterecy = [60, 110]
title = "Technology Product Performance Analysis"
xlabel = "Battery Life (hours)"
ylabel = "Performance Score"
legendlabels = ["Laptops", "Smartphones", "Tablets", "Smartwatches", "Desktops"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
fig, ax = plt.subplots(figsize=(10, 10))

# Define colors and markers for each category
colors = {
    "Laptops": "#1f77b4",  # Blue
    "Smartphones": "#ff7f0e",  # Orange
    "Tablets": "#2ca02c",  # Green
    "Smartwatches": "#d62728",  # Red
    "Desktops": "#9467bd",  # Purple
}

markers = {
    "Laptops": "o",
    "Smartphones": "^",
    "Tablets": "s",
    "Smartwatches": "p",
    "Desktops": "D",
}

for category, data in categories.items():
    ax.scatter(
        data[:, 0],
        data[:, 1],
        c=colors[category],
        marker=markers[category],
        label=category,
        alpha=0.7,
        edgecolors="w",
    )

# Draw annotation rectangle around specific region
ax.plot(
    [annotaterecx[0], annotaterecx[1]],
    [annotaterecy[1], annotaterecy[1]],
    color="black",
    lw=1,
)
ax.plot(
    [annotaterecx[0], annotaterecx[1]],
    [annotaterecy[0], annotaterecy[0]],
    color="black",
    lw=1,
)
ax.plot(
    [annotaterecx[0], annotaterecx[0]],
    [annotaterecy[0], annotaterecy[1]],
    color="black",
    lw=1,
)
ax.plot(
    [annotaterecx[1], annotaterecx[1]],
    [annotaterecy[0], annotaterecy[1]],
    color="black",
    lw=1,
)

# Create the inset with a zoomed-in view of a specific region
ax_inset = fig.add_axes(insetaxes)
for category, data in categories.items():
    ax_inset.scatter(
        data[:, 0],
        data[:, 1],
        c=colors[category],
        marker=markers[category],
        alpha=0.7,
        edgecolors="w",
    )
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add annotation to indicate the inset region
ax.annotate(
    "",
    xy=arrowstart,
    xytext=arrowend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1),
)

# Add titles and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.legend(legendlabels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_78.pdf", bbox_inches="tight")
