
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
weather_stations = {
    "station_A": np.random.normal(loc=(15, 60), scale=5, size=(50, 2)),
    "station_B": np.random.normal(loc=(20, 70), scale=5, size=(30, 2)),
    "station_C": np.random.normal(loc=(25, 80), scale=5, size=(40, 2)),
    "station_D": np.random.normal(loc=(30, 50), scale=5, size=(60, 2)),
    "station_E": np.random.normal(loc=(35, 40), scale=5, size=(70, 2)),
}

insetaxes = [0.15, 0.15, 0.2, 0.2]
insetxlim = [20, 30]
insetylim = [70, 90]
insetxticks = [20,30]
insetyticks = [70, 90]
arrowstart = (12, 20)  # Focus area for annotation
arrowend = (0.35, 0.3)
annotaterecx = [20, 30]
annotaterecy = [70, 90]
title = "Weather Station Temperature & Humidity"
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
legendlabels = {
    "station_A": "Station A",
    "station_B": "Station B",
    "station_C": "Station C",
    "station_D": "Station D",
    "station_E": "Station E",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
fig, ax = plt.subplots(figsize=(10, 10))

# Define colors and markers for each weather station, with distinct and appealing colors
colors = {
    "station_A": "#FF6347",  # Tomato
    "station_B": "#4682B4",  # SteelBlue
    "station_C": "#32CD32",  # LimeGreen
    "station_D": "#8A2BE2",  # BlueViolet
    "station_E": "#FFD700",  # Gold
}

markers = {
    "station_A": "s",
    "station_B": "o",
    "station_C": "^",
    "station_D": "d",
    "station_E": "p",
}

for station, data in weather_stations.items():
    ax.scatter(
        data[:, 0],
        data[:, 1],
        c=colors[station],
        marker=markers[station],
        label=legendlabels[station],
        alpha=0.7,
    )

# Draw annotation rectangle around a specific region
ax.plot(
    [annotaterecx[0], annotaterecx[1]],
    [annotaterecy[1], annotaterecy[1]],
    color="black",
    lw=1,
)
ax.plot(
    [annotaterecx[0], annotaterecx[1]],
    [annotaterecy[0], annotaterecy[0]],
    color="black",
    lw=1,
)
ax.plot(
    [annotaterecx[0], annotaterecx[0]],
    [annotaterecy[0], annotaterecy[1]],
    color="black",
    lw=1,
)
ax.plot(
    [annotaterecx[1], annotaterecx[1]],
    [annotaterecy[0], annotaterecy[1]],
    color="black",
    lw=1,
)

# Create the inset with a zoomed-in view of a specific region
ax_inset = fig.add_axes(insetaxes)
for station, data in weather_stations.items():
    ax_inset.scatter(
        data[:, 0],
        data[:, 1],
        c=colors[station],
        marker=markers[station],
        alpha=0.7,
    )
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add annotation to indicate the inset region
ax.annotate(
    "",
    xy=arrowstart,
    xytext=arrowend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1),
)

# Add titles and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_80.pdf", bbox_inches="tight")
