

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [1, 2, 3, 4, 5]
stress_levels = [4.0, 3.8, 3.5, 3.3, 3.0]  # Stress levels on a scale of 0-5
anxiety_levels = [3.5, 3.4, 3.2, 3.0, 2.8] # Anxiety levels on a scale of 0-5
depression_scores = [3.0, 2.8, 2.6, 2.5, 2.2] # Depression scores on a scale of 0-5
wellbeing_scores = [2.0, 2.2, 2.5, 2.8, 3.0] # Well-being scores on a scale of 0-5

# Labels for legend
label_stress = "Stress Levels"
label_anxiety = "Anxiety Levels"
label_depression = "Depression Scores"
label_wellbeing = "Well-being Scores"

# Horizontal line value
axhline_value = 3.5
xlabel="Year"
ylabel="Score (scale 0-5)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(9, 8))  # Adjusting figure size

# Colors (kept same as in original code)
color_stress = "#8bc34a"
color_anxiety = "#ffeb3b"
color_depression = "#03a9f4"
color_wellbeing = "#6d4c41"

# Plot limits
xlim_values = (1, 5)
ylim_values = (0, 5)
title="Trends in Psychological Metrics Over 5 Years"

# Axis labels
xlabel_values = ["Year 1", "Year 2", "Year 3", "Year 4", "Year 5"]
ylabel_values = [0, 1, 2, 3, 4, 5]

# Axis ticks
xticks_values = years
yticks_values = [0, 1, 2, 3, 4, 5]

plt.plot(
    years,
    stress_levels,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_stress,
    markeredgecolor="#558b2f",
    markersize=12,
    color="#558b2f",
    label=label_stress,
)
plt.plot(
    years,
    anxiety_levels,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_anxiety,
    markeredgecolor="#fbc02d",
    markersize=12,
    color="#fbc02d",
    label=label_anxiety,
)
plt.plot(
    years,
    depression_scores,
    "^-",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_depression,
    markeredgecolor="#0288d1",
    markersize=12,
    color="#0288d1",
    label=label_depression,
)
plt.plot(
    years,
    wellbeing_scores,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_wellbeing,
    markeredgecolor="#3e2723",
    markersize=12,
    color="#3e2723",
    label=label_wellbeing,
)

# Filling the area under the curves
plt.fill_between(years, stress_levels, anxiety_levels, color=color_stress, alpha=0.2)
plt.fill_between(years, anxiety_levels, depression_scores, color=color_anxiety, alpha=0.2)
plt.fill_between(years, depression_scores, wellbeing_scores, color=color_depression, alpha=0.2)
plt.fill_between(years, wellbeing_scores, color=color_wellbeing, alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="lower center", ncol=2, bbox_to_anchor=(0.5, -0.15), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Grid lines
plt.grid(True, linestyle='--', alpha=0.6)

# Title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_21.pdf", bbox_inches="tight")

