

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting (Weather Metrics over time)
x = [1, 2, 3, 4, 5]
temperature = [22, 24, 19, 21, 25]
humidity = [80, 75, 78, 73, 70]
rainfall = [50, 60, 40, 30, 80]
wind_speed = [5, 8, 6, 4, 7]

# Labels for legend
label_temperature = "Temperature (°C)"
label_humidity = "Humidity (%)"
label_rainfall = "Rainfall (mm)"
label_wind_speed = "Wind Speed (km/h)"

# Horizontal line value
axhline_value = 40

# Axis labels and title
xlabel_values = ["Jan", "Feb", "Mar", "Apr", "May"]
ylabel_values = [0, 20, 40, 60, 80, 100]
ylabel = "Value"
title = "Monthly Weather Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size to match original image dimensions

# Plot limits
xlim_values = (1, 5)
ylim_values = (0, 100)

# Axis ticks
xticks_values = x
yticks_values = ylabel_values

# Plot lines
plt.plot(
    x,
    humidity,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1f77b4",
    markeredgecolor="#1f77b4",
    markersize=8,
    color="#1f77b4",
    label=label_humidity,
)
plt.plot(
    x,
    rainfall,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff7f0e",
    markeredgecolor="#ff7f0e",
    markersize=8,
    color="#ff7f0e",
    label=label_rainfall,
)
plt.plot(
    x,
    temperature,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ca02c",
    markeredgecolor="#2ca02c",
    markersize=8,
    color="#2ca02c",
    label=label_temperature,
)
plt.plot(
    x,
    wind_speed,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#d62728",
    markeredgecolor="#d62728",
    markersize=8,
    color="#d62728",
    label=label_wind_speed,
)

# Filling the area under the curves

plt.fill_between(x, humidity, rainfall, color="#1f77b4", alpha=0.3)
plt.fill_between(x, rainfall, temperature, color="#ff7f0e", alpha=0.3)
plt.fill_between(x, temperature, wind_speed, color="#2ca02c", alpha=0.3)
plt.fill_between(x, wind_speed, 0, color="#d62728", alpha=0.3)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis、y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding labels and title
plt.xlabel("Month")
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_22.pdf", bbox_inches="tight")

