

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Sample data representing climate trends
time_step = np.linspace(0, 12, 40)  # Assuming monthly data over a year
city_a_temp = 20 + 8 * np.sin(0.5 * time_step)  # Temperature in degrees Celsius
city_b_temp = 18 + 7 * np.sin(0.5 * time_step + 1)
city_c_temp = 22 + 6 * np.sin(0.5 * time_step + 2)

# Sample data representing humidity levels
city_a_humidity = 60 + 10 * np.cos(0.5 * time_step)  # Humidity in percentage
city_b_humidity = 65 + 10 * np.sin(0.5 * time_step)
city_c_humidity = 55 + 10 * np.cos(0.5 * time_step + 1)

# Extracted variables
city_a_label = "City A"
city_b_label = "City B"
city_c_label = "City C"

temp_ylabel = "Temperature (°C)"
humidity_xlabel = "Month"
humidity_ylabel = "Humidity (%)"
legend_labels = ["City A", "City B", "City C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

# Temperature Plot Configuration
temp_ylim = [10, 35]
temp_xlim = [0, 12]
temp_yticks = [10, 15, 20, 25, 30, 35]
temp_xticks = [0, 2, 4, 6, 8, 10, 12]

# Humidity Plot Configuration
humidity_ylim = [40, 80]
humidity_xlim = [0, 12]
humidity_yticks = [40, 50, 60, 70, 80]
humidity_xticks = [0, 2, 4, 6, 8, 10, 12]

# Plot Temperature Trends
ax1.plot(time_step, city_a_temp, "o--", color="#FF5733", label=city_a_label)
ax1.fill_between(time_step, city_a_temp, color="#FDEDEC")
ax1.plot(time_step, city_b_temp, "s--", color="#33FFCE", label=city_b_label)
ax1.fill_between(time_step, city_b_temp, color="#E0F7F1")
ax1.plot(time_step, city_c_temp, "^-.", color="#335BFF", label=city_c_label)
ax1.fill_between(time_step, city_c_temp, color="#EDEEFF")
ax1.set_ylim(temp_ylim)
ax1.set_xlim(temp_xlim)
ax1.set_yticks(temp_yticks)
ax1.set_xticks(temp_xticks)
ax1.set_ylabel(temp_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Humidity Levels
ax2.plot(time_step, city_a_humidity, "o--", color="#FF5733", label=city_a_label)
ax2.fill_between(time_step, city_a_humidity, color="#FDEDEC")
ax2.plot(time_step, city_b_humidity, "s--", color="#33FFCE", label=city_b_label)
ax2.fill_between(time_step, city_b_humidity, color="#E0F7F1")
ax2.plot(time_step, city_c_humidity, "^-.", color="#335BFF", label=city_c_label)
ax2.fill_between(time_step, city_c_humidity, color="#EDEEFF")
ax2.set_ylim(humidity_ylim)
ax2.set_xlim(humidity_xlim)
ax2.set_yticks(humidity_yticks)
ax2.set_xticks(humidity_xticks)
ax2.set_xlabel(humidity_xlabel)
ax2.set_ylabel(humidity_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
city_a_line = mlines.Line2D(
    [], [], color="#FF5733", marker="o", markersize=6, label=legend_labels[0]
)
city_b_line = mlines.Line2D(
    [], [], color="#33FFCE", marker="s", markersize=6, label=legend_labels[1]
)
city_c_line = mlines.Line2D(
    [], [], color="#335BFF", marker="^", markersize=6, label=legend_labels[2]
)
plt.legend(
    handles=[city_a_line, city_b_line, city_c_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=6,
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_24.pdf", bbox_inches="tight")

