
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
year = np.linspace(2000, 2040, 40)
avg_income_region1 = 30000 + 1000 * (year - 2000)
avg_income_region2 = 25000 + 1100 * (year - 2000)
avg_income_region3 = 27000 + 1050 * (year - 2000)
edu_level_region1 = 10 + 0.2 * (year - 2000)
edu_level_region2 = 9 + 0.25 * (year - 2000)
edu_level_region3 = 8 + 0.3 * (year - 2000)

# Extracted variables
income_label_region1 = "Region 1"
income_label_region2 = "Region 2"
income_label_region3 = "Region 3"
edu_label_region1 = "Region 1"
edu_label_region2 = "Region 2"
edu_label_region3 = "Region 3"

income_ylabel = "Average Income (USD)"
edu_xlabel = "Year"
edu_ylabel = "Average Education Level (Years)"
legend_labels = ["Region 1", "Region 2", "Region 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 10))

income_ylim = [25000, 75000]
income_xlim = [2000, 2040]
income_yticks = np.arange(25000, 80000, 10000)
income_xticks = np.arange(2000, 2041, 10)

edu_ylim = [8, 24]
edu_xlim = [2000, 2040]
edu_yticks = np.arange(8, 25, 2)
edu_xticks = np.arange(2000, 2041, 10)

# Plot Average Income Growth
ax1.plot(year, avg_income_region1, "o-", color="#1f77b4", label=income_label_region1)
ax1.fill_between(year, avg_income_region1, color="#aec7e8", alpha=0.5)
ax1.plot(year, avg_income_region2, "s--", color="#ff7f0e", label=income_label_region2)
ax1.fill_between(year, avg_income_region2, color="#ffbb78", alpha=0.5)
ax1.plot(year, avg_income_region3, "^-", color="#2ca02c", label=income_label_region3)
ax1.fill_between(year, avg_income_region3, color="#98df8a", alpha=0.5)
ax1.set_ylim(income_ylim)
ax1.set_xlim(income_xlim)
ax1.set_yticks(income_yticks)
ax1.set_xticks(income_xticks)
ax1.set_ylabel(income_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.set_title("Average Income Growth")

# Plot Average Education Level
ax2.plot(year, edu_level_region1, "o-", color="#1f77b4", label=edu_label_region1)
ax2.fill_between(year, edu_level_region1, color="#aec7e8", alpha=0.5)
ax2.plot(year, edu_level_region2, "s--", color="#ff7f0e", label=edu_label_region2)
ax2.fill_between(year, edu_level_region2, color="#ffbb78", alpha=0.5)
ax2.plot(year, edu_level_region3, "^-", color="#2ca02c", label=edu_label_region3)
ax2.fill_between(year, edu_level_region3, color="#98df8a", alpha=0.5)
ax2.set_ylim(edu_ylim)
ax2.set_xlim(edu_xlim)
ax2.set_yticks(edu_yticks)
ax2.set_xticks(edu_xticks)
ax2.set_xlabel(edu_xlabel)
ax2.set_ylabel(edu_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.set_title("Average Education Level")

# Create custom legend
blue_line = mlines.Line2D(
    [], [], color="#1f77b4", marker="o", markersize=6, label=legend_labels[0]
)
orange_line = mlines.Line2D(
    [], [], color="#ff7f0e", marker="s", markersize=6, label=legend_labels[1]
)
green_line = mlines.Line2D(
    [], [], color="#2ca02c", marker="^", markersize=6, label=legend_labels[2]
)
plt.legend(
    handles=[blue_line, orange_line, green_line],
    loc="lower center",
    bbox_to_anchor=(0.5, -0.2),
    ncol=3,
    frameon=False,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_25.pdf", bbox_inches="tight")
