

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot with stock market trends
months = np.array([0, 1, 2, 3, 4])
technology = np.array([105, 110, 120, 115, 125]) + np.random.normal(0, 2, 5)  # Small noise for realism
health = np.array([98, 100, 103, 101, 106]) + np.random.normal(0, 2, 5)
finance = np.array([90, 92, 95, 93, 98])
energy = np.array([75, 77, 80, 78, 83])
market_avg = np.linspace(100, 100, len(months))  # Constant market average

# Extracted variables
fill_label_technology = "Technology Sector"
fill_label_health = "Health Sector"
fill_label_finance = "Finance Sector"
fill_label_energy = "Energy Sector"
plot_label_market_avg = "Market Average Index"
title_text = "Stock Market Trends Across Sectors"
xlabel_text = "Months"
ylabel_text = "Stock Index Value"
legend_title = "Sectors"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot with a different visualization style
plt.figure(figsize=(10, 6))

xlim_values = (min(months), max(months))
ylim_values = (70, 130)
xticks_values = months
yticks_values = [70, 80, 90, 100, 110, 120, 130]
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.12)
legend_ncol = 5

plt.fill_between(
    months, technology, color="#1f77b4", alpha=0.3, label=fill_label_technology
)
plt.fill_between(
    months,
    health,
    color="#2ca02c",
    alpha=0.3,
    label=fill_label_health,
)
plt.fill_between(
    months, finance, color="#ff7f0e", alpha=0.3, label=fill_label_finance
)
plt.fill_between(
    months,
    energy,
    color="#d62728",
    alpha=0.3,
    label=fill_label_energy,
)
plt.plot(
    months,
    market_avg,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_market_avg,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_27.pdf", bbox_inches="tight")

