

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(0)
years = ["2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021"]
adopters = np.array([1, 1.5, 2.5, 3, 4, 5.5, 6, 7])
revenue = np.array([0.5, 1, 1.8, 2.2, 2.8, 3.5, 4, 4.5])
satisfaction = np.array([3, 3.5, 3.8, 4, 4.2, 4.5, 4.3, 4.6])

# Calculate cumulative values for stacked area chart
cumulative_adopters = adopters
cumulative_revenue = cumulative_adopters + revenue
cumulative_satisfaction = cumulative_revenue + satisfaction

# Positions for the bars on the x-axis
ind = np.arange(len(years))

# Variables for plot configuration
adopters_label = "Adopters (millions)"
revenue_label = "Revenue (billion USD)"
satisfaction_label = "User Satisfaction (rating)"
xlabel_text = "Year"
ylabel_text = "Technology Metrics"
title_text = "Technology Adoption Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

xlim_values = (0, 7)
ylim_values = (0, 16)

yticks_values = np.arange(0, 17, 1)
legend_location = "upper center"
legend_fontsize = 12
legend_frameon = False
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 3
legend_bbox_to_anchor = (0.5, 1.2)

ax.fill_between(
    years, 0, cumulative_adopters, label=adopters_label, color="#FF6F61", alpha=0.7
)
ax.fill_between(
    years,
    cumulative_adopters,
    cumulative_revenue,
    label=revenue_label,
    color="#6B5B95",
    alpha=0.7,
)
ax.fill_between(
    years,
    cumulative_revenue,
    cumulative_satisfaction,
    label=satisfaction_label,
    color="#88B04B",
    alpha=0.7,
)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

ax.set_yticks(yticks_values)
ax.set_ylim(*ylim_values)
ax.set_xlim(*xlim_values)

ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.2)
ax.tick_params(axis="both", which="both", color="gray")

ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_30.pdf", bbox_inches="tight")

