

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(42)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
public_transport_usage = np.array([20, 25, 30, 35, 40, 38, 45, 50, 48, 55, 60, 65])
private_vehicle_usage = np.array([60, 58, 55, 53, 50, 48, 45, 43, 40, 38, 35, 33])
cycling = np.array([5, 7, 10, 12, 15, 14, 18, 20, 22, 25, 27, 30])

# Calculate cumulative values for stacked area chart
cumulative_public_transport_usage = public_transport_usage
cumulative_private_vehicle_usage = cumulative_public_transport_usage + private_vehicle_usage
cumulative_cycling = cumulative_private_vehicle_usage + cycling

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Variables for plot configuration
public_transport_label = "Public Transport Usage"
private_vehicle_label = "Private Vehicle Usage"
cycling_label = "Cycling"
xlabel_text = "Month"
ylabel_text = "Transportation Usage (%)"
title_text = "Cumulative Transportation Usage Over Time"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 5))  # Adjusted for better aspect ratio

xlim_values = (0, 11)
ylim_values = (0, 150)

yticks_values = np.arange(0, 151, 10)
legend_location = "upper left"
legend_fontsize = 12
legend_frameon = False
legend_shadow = False
legend_facecolor = "#ffffff"
legend_ncol = 1
legend_bbox_to_anchor = (0.1, 1.0)

ax.fill_between(
    months, 0, cumulative_public_transport_usage, label=public_transport_label, color="#66c2a5", alpha=0.7
)
ax.fill_between(
    months,
    cumulative_public_transport_usage,
    cumulative_private_vehicle_usage,
    label=private_vehicle_label,
    color="#fc8d62",
    alpha=0.7,
)
ax.fill_between(
    months,
    cumulative_private_vehicle_usage,
    cumulative_cycling,
    label=cycling_label,
    color="#8da0cb",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.1)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_31.pdf", bbox_inches="tight")
