
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

year = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020]
popularity_by_media = {
    "print": [500, 480, 450, 420, 380, 350, 300, 250],
    "radio": [100, 200, 300, 350, 320, 300, 280, 250],
    "tv": [50, 100, 200, 300, 400, 450, 480, 460],
    "internet": [0, 0, 0, 50, 200, 400, 600, 700],
    "social_media": [0, 0, 0, 0, 50, 200, 400, 600],
    "streaming": [0, 0, 0, 0, 0, 50, 200, 400],
}

# Extracted variables
legend_labels = list(popularity_by_media.keys())
xlabel_value = "Year"
ylabel_value = "Popularity (arbitrary units)"
title_value = "Media Popularity Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

xlim_values = (1950, 2020)
ylim_values = (0, 2600)
legend_loc = "upper center"
legend_reverse = False
legend_frameon = False
legend_ncol = 6
legend_bbox_to_anchor = (0.5, 1.08)
title_y_position = 1.08

colors = ["#88c999", "#a088c9", "#c99888", "#c9a088", "#88a0c9"]

ax.stackplot(
    year,
    popularity_by_media.values(),
    labels=legend_labels,
    alpha=0.8,
    colors=colors,
    linewidths=2.5,
    edgecolor="gray",
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position, fontsize=14)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_35.pdf", bbox_inches="tight")
