
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate new financial data
years = np.arange(2015, 2020)
revenue = [100, 120, 130, 150, 160]  # Annual Revenue in USD million
expenses = [70, 75, 80, 85, 90]  # Annual Expenses in USD million
profits = [30, 45, 50, 65, 70]  # Annual Profits in USD million

# Labels for legend
label_revenue = "Annual Revenue"
label_expenses = "Annual Expenses"
label_profits = "Annual Profits"

# Title and labels
plot_title = "Financial Performance Over the Years"
xlabel_text = "Years"
ylabel_text = "Million USD"

xlim_values = (2015, 2019)
ylim_values = (0, 170)

# Axis labels
xlabel_values = ["2015", "2016", "2017", "2018", "2019"]
ylabel_values = [0, 50, 100, 150, 170]

# Axis ticks
xticks_values = years
yticks_values = [0, 50, 100, 150, 170]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits

# Plotting the data with optimized style
title_fontsize = 16
label_fontsize = 14
title_pad = 20
plt.figure(figsize=(12, 8))  # Adjusting figure size to fit better

# Revenue line with markers
plt.plot(
    years,
    revenue,
    'o-',
    clip_on=False,
    zorder=10,
    markerfacecolor="#FF5733",
    markeredgecolor="#C70039",
    markersize=10,
    color="#900C3F",
    label=label_revenue,
    linewidth=2,
)

# Expenses line with markers
plt.plot(
    years,
    expenses,
    's-',
    clip_on=False,
    zorder=10,
    markerfacecolor="#FFC300",
    markeredgecolor="#FF5733",
    markersize=10,
    color="#FF5733",
    label=label_expenses,
    linewidth=2,
)

# Profits line with markers
plt.plot(
    years,
    profits,
    'd-',
    clip_on=False,
    zorder=10,
    markerfacecolor="#DAF7A6",
    markeredgecolor="#FFC300",
    markersize=10,
    color="#FFC300",
    label=label_profits,
    linewidth=2,
)

# Filling the area under the curves
plt.fill_between(years, revenue, expenses, color="#FF5733", alpha=0.3)
plt.fill_between(years, expenses, profits, color="#FFC300", alpha=0.3)
plt.fill_between(years, profits, 0, color="#DAF7A6", alpha=0.3)

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis and y-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding title and labels
plt.title(plot_title, fontsize=title_fontsize, pad=title_pad)
plt.xlabel(xlabel_text, fontsize=label_fontsize)
plt.ylabel(ylabel_text, fontsize=label_fontsize)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_36.pdf", bbox_inches="tight")
