
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
years = [2018, 2019, 2020, 2021, 2022]
smartphones = [150, 170, 200, 230, 260]  # Annual Smartphone Usage in Millions
laptops = [80, 90, 100, 115, 130]  # Annual Laptop Usage in Millions
tablets = [60, 55, 70, 65, 75]  # Annual Tablet Usage in Millions

# Labels for legend
label_smartphones = "Smartphone Usage"
label_laptops = "Laptop Usage"
label_tablets = "Tablet Usage"

# Title and Labels
plot_title = "Communication Device Usage Over the Years"
xlabel_text = "Years"
ylabel_text = "Device Usage (Millions)"

xlim_values = (2018, 2022)
ylim_values = (0, 350)

# Axis labels
xlabel_values = ["2018", "2019", "2020", "2021", "2022"]
ylabel_values = [0, 50, 100, 150, 200, 250, 300, 350]

# Axis ticks
xticks_values = years
yticks_values = [0, 50, 100, 150, 200, 250, 300, 350]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits

# Plotting the data
title_fontsize = 16
label_fontsize = 14
title_pad = 20
plt.figure(figsize=(12, 8))  # Adjusting figure size to fit better

color_smartphones = "#1f78b4"
color_laptops = "#ff7f0e"
color_tablets = "#2ca02c"

plt.plot(
    years,
    smartphones,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_smartphones,
    markeredgecolor=color_smartphones,
    markersize=10,
    color=color_smartphones,
    label=label_smartphones,
)
plt.plot(
    years,
    laptops,
    "--",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_laptops,
    markeredgecolor=color_laptops,
    markersize=10,
    color=color_laptops,
    label=label_laptops,
)
plt.plot(
    years,
    tablets,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_tablets,
    markeredgecolor=color_tablets,
    markersize=10,
    color=color_tablets,
    label=label_tablets,
)

# Filling the area under the curves
plt.fill_between(years, smartphones, laptops, color=color_smartphones, alpha=0.4)
plt.fill_between(years, laptops, tablets, color=color_laptops, alpha=0.4)
plt.fill_between(years, tablets, 0, color=color_tablets, alpha=0.4)

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis and y-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding title and labels
plt.title(plot_title, fontsize=title_fontsize, pad=title_pad)
plt.xlabel(xlabel_text, fontsize=label_fontsize)
plt.ylabel(ylabel_text, fontsize=label_fontsize)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_37.pdf", bbox_inches="tight")
