
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Simulated data for stock prices and trading volume over months
months = np.linspace(1, 12, 12)  # 12 months
stock_prices = np.array([150, 155, 160, 158, 165, 170, 175, 180, 178, 172, 168, 165])  # Stock prices in USD
stock_prices_pred = stock_prices + np.random.normal(0, 5, len(stock_prices))
trading_volume = np.array([500, 520, 530, 510, 540, 570, 590, 600, 580, 560, 550, 540])  # Trading volume in thousands
trading_volume_pred = trading_volume + np.random.normal(0, 20, len(trading_volume))

# Extracted variables
stock_prices_label = "Actual Stock Prices"
stock_prices_pred_label = "Predicted Stock Prices"
trading_volume_label = "Actual Trading Volume"
trading_volume_pred_label = "Predicted Trading Volume"

stock_prices_ylabel = "Stock Prices (USD)"
trading_volume_xlabel = "Months"
trading_volume_ylabel = "Trading Volume (Thousands)"
legend_labels = ["Actual", "Predicted"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
stock_prices_ylim = [140, 190]
stock_prices_xlim = [1, 12]
stock_prices_yticks = np.arange(140, 200, 10)
stock_prices_xticks = np.arange(1, 13, 1)
trading_volume_ylim = [480, 620]
trading_volume_xlim = [1, 12]
trading_volume_yticks = np.arange(480, 640, 20)
trading_volume_xticks = stock_prices_xticks

legend_loc = "upper right"
legend_bbox_to_anchor = (1, 1.15)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

# Plot Stock Prices
ax1.plot(months, stock_prices, "o-", color="#FF5733", label=stock_prices_label)
ax1.fill_between(months, stock_prices, color="#FFC300", alpha=0.5)
ax1.plot(months, stock_prices_pred, "s--", color="#C70039", label=stock_prices_pred_label)
ax1.fill_between(months, stock_prices_pred, color="#FF5733", alpha=0.3)
ax1.set_ylim(stock_prices_ylim)
ax1.set_xlim(stock_prices_xlim)
ax1.set_yticks(stock_prices_yticks)
ax1.set_xticks(stock_prices_xticks)
ax1.set_ylabel(stock_prices_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Trading Volume
ax2.plot(months, trading_volume, "o-", color="#3498DB", label=trading_volume_label)
ax2.fill_between(months, trading_volume, color="#85C1E9", alpha=0.5)
ax2.plot(months, trading_volume_pred, "s--", color="#1F618D", label=trading_volume_pred_label)
ax2.fill_between(months, trading_volume_pred, color="#3498DB", alpha=0.3)
ax2.set_ylim(trading_volume_ylim)
ax2.set_xlim(trading_volume_xlim)
ax2.set_yticks(trading_volume_yticks)
ax2.set_xticks(trading_volume_xticks)
ax2.set_xlabel(trading_volume_xlabel)
ax2.set_ylabel(trading_volume_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
red_line = mlines.Line2D([], [], color="#FF5733", marker="o", markersize=6, label=legend_labels[0])
blue_line = mlines.Line2D([], [], color="#C70039", marker="s", markersize=6, label=legend_labels[1])
plt.legend(handles=[red_line, blue_line], loc=legend_loc, bbox_to_anchor=legend_bbox_to_anchor, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_43.pdf", bbox_inches="tight")
