# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(32)
# Sample data for 12 months for a historical domain
months = np.arange(1, 13)
stone_tools = np.random.normal(loc=400, scale=100, size=12)
population_growth = 50 + 20 * np.cos(np.pi * months / 6)

# Extracted variables for labels and settings
tools_label = "Stone Tools Found"
population_label = "Population Growth (%)"

legend_labels = ["Stone Tools", "Population Growth"]
tools_ylabel = "Tools Found (items)"
population_ylabel = "Growth (%)"
months_xlabel = "Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
tools_ylim = [0, 800]
population_ylim = [0, 100]
months_xticks = np.arange(1, 13, 1)
months_xlim = [1, 12]
yticks_tools = np.arange(0, 801, 200)
yticks_population = np.arange(0, 101, 25)
legend_loc = "lower center"
legend_bbox_to_anchor = (0.5, -0.15)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 18))

# Plot Stone Tools Found
ax1.plot(months, stone_tools, "D--", color="#1f77b4", label=tools_label)
ax1.set_ylim(tools_ylim)
ax1.set_xlim(months_xlim)
ax1.set_xticks(months_xticks)
ax1.set_yticks(yticks_tools)
ax1.set_ylabel(tools_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True)

# Plot Population Growth
ax2.plot(months, population_growth, "o-", color="#ff7f0e", label=population_label)
ax2.set_ylim(population_ylim)
ax2.set_xlim(months_xlim)
ax2.set_yticks(yticks_population)
ax2.set_xticks(months_xticks)
ax2.set_xlabel(months_xlabel)
ax2.set_ylabel(population_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True)

# Create custom legend
blue_diamond = mlines.Line2D(
    [],
    [],
    color="#1f77b4",
    marker="D",
    markersize=8,
    label=legend_labels[0],
    linestyle="None",
)
orange_circle = mlines.Line2D(
    [], [], color="#ff7f0e", marker="o", markersize=8, label=legend_labels[1]
)
plt.legend(
    handles=[blue_diamond, orange_circle],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_46.pdf", bbox_inches="tight")
