

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data for 12 months
months = np.arange(1, 13)
average_temperature = np.array([5, 7, 12, 18, 23, 27, 29, 28, 24, 18, 11, 6])
monthly_rainfall = np.array([50, 40, 45, 60, 75, 90, 80, 85, 70, 65, 55, 45])

# Extracted variables for labels and settings
temperature_label = "Average Temperature (°C)"
rainfall_label = "Monthly Rainfall (mm)"

legend_labels = ["Average Temperature", "Monthly Rainfall"]
temperature_ylabel = "Average Temperature (°C)"
rainfall_ylabel = "Monthly Rainfall (mm)"
months_xlabel = "Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
temperature_ylim = [-10, 40]
rainfall_ylim = [0, 300]
months_xticks = np.arange(1, 13, 1)
months_xlim = [1, 12]
yticks_temperature = np.arange(-10, 41, 10)
yticks_rainfall = np.arange(0, 301, 50)
legend_loc = "upper left"
legend_bbox_to_anchor = (0.85, 1)
legend_ncol = 1
legend_frameon = True

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 23))

# Plot Average Temperature
ax1.plot(months, average_temperature, "o--", color="#2ca02c", label=temperature_label, linewidth=2)
ax1.set_ylim(temperature_ylim)
ax1.set_xlim(months_xlim)
ax1.set_xticks(months_xticks)
ax1.set_yticks(yticks_temperature)
ax1.set_ylabel(temperature_ylabel)
ax1.tick_params(axis="both", which="both", length=5)
ax1.grid(True)

# Plot Monthly Rainfall
ax2.plot(months, monthly_rainfall, "s-", color="#9467bd", label=rainfall_label, linewidth=2)
ax2.set_ylim(rainfall_ylim)
ax2.set_xlim(months_xlim)
ax2.set_yticks(yticks_rainfall)
ax2.set_xticks(months_xticks)
ax2.set_xlabel(months_xlabel)
ax2.set_ylabel(rainfall_ylabel)
ax2.tick_params(axis="both", which="both", length=5)
ax2.grid(True)

# Create custom legend
green_dot = mlines.Line2D(
    [], [], color="#2ca02c", marker="o", markersize=8, label=legend_labels[0], linestyle="None"
)
purple_square = mlines.Line2D(
    [], [], color="#9467bd", marker="s", markersize=8, label=legend_labels[1], linestyle="None"
)
plt.legend(
    handles=[green_dot, purple_square],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_47.pdf", bbox_inches="tight")

