

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data representing stock prices of different companies over years
years = np.array([2000, 2005, 2010, 2015, 2020])

company1_stock = np.array([50, 75, 100, 125, 150]) + np.random.normal(0, 5, 5)
company2_stock = np.array([60, 70, 85, 110, 120]) + np.random.normal(0, 5, 5)
company3_stock = np.array([40, 55, 75, 95, 110]) + np.random.normal(0, 5, 5)
company4_stock = np.array([45, 65, 90, 115, 130]) + np.random.normal(0, 5, 5)

# Extracted variables
fill_label_company1 = "Company A"
fill_label_company2 = "Company B"
fill_label_company3 = "Company C"
fill_label_company4 = "Company D"
title_text = "Stock Price Trends Over Years"
xlabel_text = "Year"
ylabel_text = "Stock Price (USD)"
legend_title = "Company"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (30, 160)
xticks_values = years
yticks_values = np.arange(30, 161, 10)
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1

# Create the plot with an improved visualization style
plt.figure(figsize=(10, 7))
plt.fill_between(years, company1_stock, color="#2E8B57", alpha=0.7, label=fill_label_company1)
plt.fill_between(years, company2_stock, color="#4682B4", alpha=0.7, label=fill_label_company2)
plt.fill_between(years, company3_stock, color="#8A2BE2", alpha=0.7, label=fill_label_company3)
plt.fill_between(years, company4_stock, color="#FF6347", alpha=0.7, label=fill_label_company4)

# Add a title and labels
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_48.pdf", bbox_inches="tight")

