
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data representing election voting percentages in different regions over years (in %)
years = np.array([2000, 2005, 2010, 2015, 2020])

party1_votes = np.array([55, 58, 60, 59, 62]) + np.random.normal(0, 3, 5)
party2_votes = np.array([45, 47, 48, 50, 52]) + np.random.normal(0, 2.5, 5)
party3_votes = np.array([30, 32, 35, 36, 38]) + np.random.normal(0, 2, 5)
party4_votes = np.array([40, 42, 45, 47, 49]) + np.random.normal(0, 3.5, 5)

# Extracted variables
fill_label_party1 = "Party 1"
fill_label_party2 = "Party 2"
fill_label_party3 = "Party 3"
fill_label_party4 = "Party 4"
title_text = "Election Voting Percentages Over Years"
xlabel_text = "Year"
ylabel_text = "Voting Percentage (%)"
legend_title = "Party"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (25.0, 70.0)
xticks_values = years
yticks_values = np.arange(25.0, 75.0, 5.0)
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1

# Create the plot with a different visualization style
plt.figure(figsize=(10, 7))
plt.fill_between(years, party1_votes, color="#1f77b4", alpha=0.5, label=fill_label_party1)
plt.fill_between(years, party2_votes, color="#ff7f0e", alpha=0.5, label=fill_label_party2)
plt.fill_between(years, party3_votes, color="#2ca02c", alpha=0.5, label=fill_label_party3)
plt.fill_between(years, party4_votes, color="#d62728", alpha=0.5, label=fill_label_party4)

# Add a title and labels
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_50.pdf", bbox_inches="tight")
