
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New Data for Different Domain (Geography Data)
months = [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
]
avg_rainfall = np.random.randint(50, 200, size=len(months))  # mm
avg_temperature = np.random.randint(5, 35, size=len(months))  # Celsius
avg_humidity = np.random.randint(30, 90, size=len(months))  # Percentage

# Calculate cumulative values for stacked area chart
cumulative_rainfall = avg_rainfall
cumulative_temperature = cumulative_rainfall + avg_temperature
cumulative_humidity = cumulative_temperature + avg_humidity

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Variables for plot configuration
rainfall_label = "Average Monthly Rainfall (mm)"
temperature_label = "Average Monthly Temperature (°C)"
humidity_label = "Average Monthly Humidity (%)"
xlabel_text = "Months"
ylabel_text = "Geographic Measurements"
title_text = "Monthly Geographic Observations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 11)
ylim_values = (0, max(cumulative_humidity) + 20)

yticks_values = range(0, max(cumulative_humidity) + 20, 100)
legend_location = "upper center"
legend_fontsize = 10
legend_frameon = True
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 3
legend_bbox_to_anchor = (0.5, 1.15)
title_fontsize = 16
title_y = 1.2
xlabel_fontsize = 14
ylabel_fontsize = 14
tick_params_color = "gray"
grid_linestyle = "--"
grid_alpha = 0.5

# Plot
fig, ax = plt.subplots(figsize=(10, 5))  # Adjusted for better aspect ratio
ax.fill_between(
    months, 0, cumulative_rainfall, label=rainfall_label, color="#FF6F61", alpha=0.7
)
ax.fill_between(
    months,
    cumulative_rainfall,
    cumulative_temperature,
    label=temperature_label,
    color="#6B5B95",
    alpha=0.7,
)
ax.fill_between(
    months,
    cumulative_temperature,
    cumulative_humidity,
    label=humidity_label,
    color="#88B04B",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel_text, fontsize=ylabel_fontsize)
ax.set_title(title_text, fontsize=title_fontsize, y=title_y)
ax.tick_params(axis="both", which="both", color=tick_params_color)
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle=grid_linestyle, alpha=grid_alpha, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_58.pdf", bbox_inches="tight")
