

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Psychological Metrics
intervention_levels = ["0", "0.125", "0.25", "0.5", "1", "2", "4", "8"]
stress_levels = np.array([10, 9.5, 9, 8, 7, 6, 5, 4])
happiness_index = np.array([3, 3.5, 4, 5, 6, 7, 8, 9])
productivity_scores = np.array([2, 2.5, 3, 4, 5, 6, 7, 8])

# Calculate cumulative values for the stacked area chart
cumulative_stress_levels = stress_levels
cumulative_happiness_index = cumulative_stress_levels + happiness_index
cumulative_productivity_scores = cumulative_happiness_index + productivity_scores

# Positions for the bars on the x-axis
ind = np.arange(len(intervention_levels))

# Variables for plot configuration
stress_levels_label = "Stress Levels"
happiness_index_label = "Happiness Index"
productivity_scores_label = "Productivity Scores"
xlabel_text = "Intervention Level"
ylabel_text = "Psychological Metrics"
title_text = "Cumulative Psychological Metrics by Intervention Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 7)
ylim_values = (0, 25)
yticks_values = np.arange(0, 26, 2)
legend_location = "upper left"
legend_fontsize = 12
legend_frameon = False
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 1
legend_bbox_to_anchor = (1.05, 1)

# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

ax.fill_between(
    intervention_levels,
    0,
    cumulative_stress_levels,
    label=stress_levels_label,
    color="#66c2a5",
    alpha=0.7,
)
ax.fill_between(
    intervention_levels,
    cumulative_stress_levels,
    cumulative_happiness_index,
    label=happiness_index_label,
    color="#fc8d62",
    alpha=0.7,
)
ax.fill_between(
    intervention_levels,
    cumulative_happiness_index,
    cumulative_productivity_scores,
    label=productivity_scores_label,
    color="#8da0cb",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)

# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)
ax.tick_params(axis="both", which="both", color="gray")

# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_61.pdf", bbox_inches="tight")

